/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.stash;

import com.google.inject.Inject;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorage;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageType;
import dev.thource.runelite.dudewheresmystuff.stash.StashUnit;
import java.util.Objects;
import java.util.Optional;
import net.runelite.api.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StashStorageManager
extends StorageManager<StashStorageType, StashStorage> {
    private static final Logger log = LoggerFactory.getLogger(StashStorageManager.class);
    private boolean updatedThisOpening = false;

    @Inject
    private StashStorageManager(DudeWheresMyStuffPlugin plugin) {
        super(plugin);
        for (StashUnit stashUnit : StashUnit.values()) {
            this.storages.add(new StashStorage(plugin, stashUnit));
        }
    }

    @Override
    public void onGameTick() {
        super.onGameTick();
        Widget stashChartWidget = this.client.getWidget(493, 2);
        if (stashChartWidget == null) {
            this.updatedThisOpening = false;
            return;
        }
        if (this.updatedThisOpening) {
            return;
        }
        this.updatedThisOpening = true;
        boolean updated = this.updateBeginnerStashChartItems();
        if (this.updateEasyStashChartItems()) {
            updated = true;
        }
        if (this.updateMediumStashChartItems()) {
            updated = true;
        }
        if (this.updateHardStashChartItems()) {
            updated = true;
        }
        if (this.updateEliteStashChartItems()) {
            updated = true;
        }
        if (this.updateMasterStashChartItems()) {
            updated = true;
        }
        if (updated) {
            this.updateStorages(this.storages);
        }
    }

    private boolean updateBeginnerStashChartItems() {
        return this.updateStashChartItems(4);
    }

    private boolean updateEasyStashChartItems() {
        return this.updateStashChartItems(6);
    }

    private boolean updateMediumStashChartItems() {
        return this.updateStashChartItems(8);
    }

    private boolean updateHardStashChartItems() {
        return this.updateStashChartItems(10);
    }

    private boolean updateEliteStashChartItems() {
        return this.updateStashChartItems(12);
    }

    private boolean updateMasterStashChartItems() {
        return this.updateStashChartItems(14);
    }

    private boolean updateStashChartItems(int childId) {
        Widget stashWidget = this.client.getWidget(493, childId);
        if (stashWidget == null) {
            return false;
        }
        Widget[] widgetChildren = stashWidget.getChildren();
        if (widgetChildren == null) {
            return false;
        }
        Optional<Object> stashStorage = Optional.empty();
        boolean built = false;
        boolean filled = false;
        for (Widget widget : widgetChildren) {
            if (widget.getType() == 4) {
                if (stashStorage.isPresent()) {
                    this.updateStashChartItem((StashStorage)stashStorage.get(), filled);
                }
                stashStorage = this.findStashStorageFromChartText(this.getChartText(widget, childId));
                built = false;
                filled = false;
                continue;
            }
            if (widget.getType() != 5 || !stashStorage.isPresent()) continue;
            if (built) {
                filled = true;
                continue;
            }
            built = true;
        }
        if (stashStorage.isPresent()) {
            this.updateStashChartItem((StashStorage)stashStorage.get(), filled);
        }
        return true;
    }

    private String getChartText(Widget widget, int childId) {
        if (Objects.equals(widget.getText(), "Warriors' Guild bank") && childId == 14) {
            return "Warriors' Guild bank (master)";
        }
        return widget.getText();
    }

    private void updateStashChartItem(StashStorage stashStorage, boolean filled) {
        stashStorage.setLastUpdated(System.currentTimeMillis());
        if (filled && stashStorage.getItems().isEmpty()) {
            for (int defaultItemId : stashStorage.getStashUnit().getDefaultItemIds()) {
                stashStorage.getItems().add(new ItemStack(defaultItemId, 1L, this.plugin));
            }
        } else if (!filled && !stashStorage.getItems().isEmpty()) {
            stashStorage.getItems().clear();
        }
    }

    private Optional<StashStorage> findStashStorageFromChartText(String text) {
        return this.storages.stream().filter(s -> Objects.equals(s.getStashUnit().getChartText(), text)).findFirst();
    }

    @Override
    public String getConfigKey() {
        return "stash";
    }
}

