/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.stash;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemContainerWatcher;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.ItemStorage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageType;
import dev.thource.runelite.dudewheresmystuff.stash.StashUnit;
import java.util.Objects;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.plugins.cluescrolls.clues.item.ItemRequirement;

public class StashStorage
extends ItemStorage<StashStorageType> {
    private final StashUnit stashUnit;
    private boolean handleWithdrawOnTick = false;
    private boolean handleDepositOnTick = false;

    protected StashStorage(DudeWheresMyStuffPlugin plugin, StashUnit stashUnit) {
        super(StashStorageType.STASH, plugin);
        this.stashUnit = stashUnit;
    }

    @Override
    protected void createStoragePanel(StorageManager<?, ?> storageManager) {
        super.createStoragePanel(storageManager);
        assert (this.storagePanel != null);
        this.storagePanel.setTitleToolTip(this.stashUnit.getChartText());
        this.createComponentPopupMenu(storageManager);
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        if (this.stashUnit.getStashUnitData().getWorldPoints()[0].distanceTo(this.plugin.getClient().getLocalPlayer().getWorldLocation()) > 3) {
            return false;
        }
        if (Objects.equals(chatMessage.getMessage(), "You withdraw your items from the STASH unit.")) {
            this.handleWithdrawOnTick = true;
        } else if (Objects.equals(chatMessage.getMessage(), "You deposit your items into the STASH unit.")) {
            this.handleDepositOnTick = true;
        }
        return true;
    }

    @Override
    public boolean onGameTick() {
        boolean updated;
        if (this.handleWithdrawOnTick && this.handleDepositOnTick) {
            return false;
        }
        boolean bl = updated = this.handleWithdrawOnTick || this.handleDepositOnTick;
        if (this.handleWithdrawOnTick) {
            this.handleWithdraw();
        }
        if (this.handleDepositOnTick) {
            this.handleDeposit();
        }
        this.handleWithdrawOnTick = false;
        this.handleDepositOnTick = false;
        return updated;
    }

    private void handleWithdraw() {
        this.lastUpdated = System.currentTimeMillis();
        this.items.clear();
    }

    private void handleDeposit() {
        this.lastUpdated = System.currentTimeMillis();
        this.items.clear();
        block0: for (ItemStack itemStack : ItemContainerWatcher.getInventoryWatcher().getItemsRemovedLastTick()) {
            for (ItemRequirement itemRequirement : this.stashUnit.getItemRequirements()) {
                if (!itemRequirement.fulfilledBy(itemStack.getId())) continue;
                this.items.add(itemStack);
                continue block0;
            }
        }
    }

    @Override
    public String getName() {
        if (this.stashUnit == null) {
            return "";
        }
        return this.stashUnit.getLocationName();
    }

    @Override
    protected String getConfigKey(String managerConfigKey) {
        return managerConfigKey + "." + this.stashUnit.getStashUnitData().getObjectId();
    }

    public StashUnit getStashUnit() {
        return this.stashUnit;
    }

    public boolean isHandleWithdrawOnTick() {
        return this.handleWithdrawOnTick;
    }

    public boolean isHandleDepositOnTick() {
        return this.handleDepositOnTick;
    }
}

