/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.playerownedhouse;

import com.google.common.collect.ImmutableList;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemContainerWatcher;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorage;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.config.ConfigManager;

public class Menagerie
extends PlayerOwnedHouseStorage {
    private static final List<Integer> ITEM_CONTAINER_ITEM_IDS = Arrays.asList(3695, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, 1566, 1567, 1568, 1569, 1570, 1571, 1572, 6555, 6556, 6557, 6558, 6559, 6560, 6549, 6550, 6551, 6552, 6553, 6554, 7583, 7582, 7581, 7585, 7584, 6670, 6671, 6672, 7771);
    public static final List<List<Integer>> VARPLAYER_BITS_TO_ITEM_IDS_LIST;
    private int petBits1;
    private int petBits2;
    private final List<ItemStack> compiledItems = new ArrayList<ItemStack>();
    private final List<ItemStack> varplayerItems = new ArrayList<ItemStack>();
    private boolean wasBeingFollowedLastTick = false;

    protected Menagerie(DudeWheresMyStuffPlugin plugin) {
        super(PlayerOwnedHouseStorageType.MENAGERIE, plugin);
    }

    @Override
    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = super.getSaveValues();
        saveValues.add(SaveFieldFormatter.format(this.petBits1));
        saveValues.add(SaveFieldFormatter.format(this.petBits2));
        return saveValues;
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        this.petBits1 = SaveFieldLoader.loadInt(values, this.petBits1);
        this.petBits2 = SaveFieldLoader.loadInt(values, this.petBits2);
    }

    private void updateItems() {
        this.compiledItems.clear();
        this.compiledItems.addAll(this.items);
        this.compiledItems.addAll(this.varplayerItems);
    }

    private boolean updateRemovedInventoryItems() {
        boolean updated = false;
        ItemContainerWatcher inventoryWatcher = ItemContainerWatcher.getInventoryWatcher();
        block0: for (ItemStack itemStack : inventoryWatcher.getItemsAddedLastTick()) {
            if (!ITEM_CONTAINER_ITEM_IDS.contains(itemStack.getId())) continue;
            ListIterator listIterator = this.items.listIterator();
            while (listIterator.hasNext()) {
                ItemStack item = (ItemStack)listIterator.next();
                if (item.getId() != itemStack.getId()) continue;
                listIterator.remove();
                updated = true;
                continue block0;
            }
        }
        return updated;
    }

    private boolean updateFromInventoryWatcher(boolean isBeingFollowed) {
        boolean updated = false;
        ItemContainerWatcher inventoryWatcher = ItemContainerWatcher.getInventoryWatcher();
        if (!isBeingFollowed || this.wasBeingFollowedLastTick) {
            for (ItemStack itemStack : inventoryWatcher.getItemsRemovedLastTick()) {
                if (!ITEM_CONTAINER_ITEM_IDS.contains(itemStack.getId())) continue;
                this.items.add(itemStack);
                updated = true;
            }
        }
        if (this.updateRemovedInventoryItems()) {
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean onGameTick() {
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.plugin.getClient(), (LocalPoint)this.plugin.getClient().getLocalPlayer().getLocalLocation());
        if (Region.get(worldPoint.getRegionID()) != Region.REGION_POH) {
            return false;
        }
        boolean isBeingFollowed = this.plugin.getClient().getVarpValue(447) != -1;
        boolean updated = this.updateFromInventoryWatcher(isBeingFollowed);
        if (updated) {
            this.lastUpdated = System.currentTimeMillis();
            this.updateItems();
        }
        this.wasBeingFollowedLastTick = isBeingFollowed;
        return updated;
    }

    @Override
    public boolean onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() != ((PlayerOwnedHouseStorageType)this.type).getItemContainerId()) {
            return false;
        }
        this.lastUpdated = System.currentTimeMillis();
        this.items.clear();
        for (Item item : itemContainerChanged.getItemContainer().getItems()) {
            if (item.getId() == -1) continue;
            this.items.add(new ItemStack(item.getId(), 1L, this.plugin));
        }
        this.updateItems();
        return true;
    }

    void rebuildPetsFromBits() {
        this.varplayerItems.clear();
        int varpIndex = 0;
        for (List<Integer> itemIds : VARPLAYER_BITS_TO_ITEM_IDS_LIST) {
            int value = varpIndex == 0 ? this.petBits1 : this.petBits2;
            for (int i = 0; i < itemIds.size(); ++i) {
                if (((long)value & 1L << i) == 0L) continue;
                this.varplayerItems.add(new ItemStack(itemIds.get(i), 1L, this.plugin));
            }
            ++varpIndex;
        }
        this.updateItems();
    }

    @Override
    public boolean onVarbitChanged() {
        int oldPetBits1 = this.petBits1;
        int oldPetBits2 = this.petBits2;
        this.petBits1 = this.plugin.getClient().getVarpValue(864);
        this.petBits2 = this.plugin.getClient().getVarpValue(1416);
        if (this.petBits1 != oldPetBits1 || this.petBits2 != oldPetBits2) {
            this.rebuildPetsFromBits();
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.compiledItems;
    }

    @Override
    public void reset() {
        super.reset();
        this.items.clear();
        this.compiledItems.clear();
        this.varplayerItems.clear();
        this.petBits1 = 0;
        this.petBits2 = 0;
    }

    @Override
    public void load(ConfigManager configManager, String managerConfigKey, String profileKey) {
        super.load(configManager, managerConfigKey, profileKey);
        this.rebuildPetsFromBits();
    }

    static {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add(Arrays.asList(11995, 12643, 12644, 12645, 12703, 12649, 12650, 12651, 12652, 12646, 12653, 12647, 12648, 12655, 12816, 12921, 13071, 13177, 13178, 13179, 13181, 13225, 13247, 13262, 13320, 13321, 13322, 13323, 19730, 20659, 20661, 20665));
        builder.add(Arrays.asList(20663, 20693, 20851, 21273, 21291, 21509, 21748, 21992, 22473, 22746, 23495, 23757, 23760, 24491, 25348, 25602, 26348, 26901, 27352, 27590));
        VARPLAYER_BITS_TO_ITEM_IDS_LIST = builder.build();
    }
}

