/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.minigames;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorage;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.math.NumberUtils;

public class MahoganyHomes
extends MinigamesStorage {
    private final Pattern chatMessagePattern = Pattern.compile("You have completed <col=ef1020>\\d+</col> contracts with a total of <col=ef1020>(\\d+)</col> points\\.");
    private final ItemStack points = new ItemStack(8794, "Points", 0L, 0, 0, true);

    MahoganyHomes(DudeWheresMyStuffPlugin plugin) {
        super(MinigamesStorageType.MAHOGANY_HOMES, plugin);
        this.items.add(this.points);
    }

    @Override
    public boolean onGameTick() {
        Widget widget = this.plugin.getClient().getWidget(673, 8);
        if (widget == null) {
            return false;
        }
        this.points.setQuantity(NumberUtils.toInt((String)Text.removeTags((String)widget.getText()).replaceAll("\\D+", ""), (int)0));
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        Matcher matcher = this.chatMessagePattern.matcher(chatMessage.getMessage().replace(",", ""));
        if (!matcher.matches()) {
            return false;
        }
        this.points.setQuantity(NumberUtils.toInt((String)matcher.group(1), (int)0));
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    public Pattern getChatMessagePattern() {
        return this.chatMessagePattern;
    }

    public ItemStack getPoints() {
        return this.points;
    }
}

