/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.minigames;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.minigames.MageTrainingArenaPoint;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorage;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.math.NumberUtils;

public class MageTrainingArena
extends MinigamesStorage {
    private final ItemStack telekineticPoints = new ItemStack(563, "Telekinetic Points", 0L, 0, 0, true);
    private final ItemStack graveyardPoints = new ItemStack(6883, "Graveyard Points", 0L, 0, 0, true);
    private final ItemStack enchantmentPoints = new ItemStack(6898, "Enchantment Points", 0L, 0, 0, true);
    private final ItemStack alchemistPoints = new ItemStack(617, "Alchemist Points", 0L, 0, 0, true);
    private final Map<ItemStack, MageTrainingArenaPoint> pointData = new HashMap<ItemStack, MageTrainingArenaPoint>();
    private Widget shopWidget = null;

    MageTrainingArena(DudeWheresMyStuffPlugin plugin) {
        super(MinigamesStorageType.MAGE_TRAINING_ARENA, plugin);
        this.items.add(this.telekineticPoints);
        this.items.add(this.graveyardPoints);
        this.items.add(this.enchantmentPoints);
        this.items.add(this.alchemistPoints);
        this.pointData.put(this.telekineticPoints, new MageTrainingArenaPoint(198, 261));
        this.pointData.put(this.alchemistPoints, new MageTrainingArenaPoint(194, 262));
        this.pointData.put(this.enchantmentPoints, new MageTrainingArenaPoint(195, 263));
        this.pointData.put(this.graveyardPoints, new MageTrainingArenaPoint(196, 264));
    }

    @Override
    public boolean onGameTick() {
        return this.updateFromWidgets();
    }

    @Override
    public boolean onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == 197) {
            this.shopWidget = this.plugin.getClient().getWidget(197, 0);
        } else {
            this.pointData.forEach((itemStack, pointDatum) -> {
                if (widgetLoaded.getGroupId() != pointDatum.getWidgetId()) {
                    return;
                }
                pointDatum.widget = this.plugin.getClient().getWidget(pointDatum.getWidgetId(), 6);
            });
        }
        return this.updateFromWidgets();
    }

    @Override
    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (widgetClosed.getGroupId() == 197) {
            this.shopWidget = null;
        } else {
            this.pointData.forEach((itemStack, pointDatum) -> {
                if (widgetClosed.getGroupId() != pointDatum.getWidgetId()) {
                    return;
                }
                pointDatum.widget = null;
            });
        }
    }

    boolean updateFromWidgets() {
        if (this.shopWidget != null) {
            this.lastUpdated = System.currentTimeMillis();
            this.pointData.forEach((itemStack, pointDatum) -> {
                int newPoints = this.plugin.getClient().getVarpValue(pointDatum.getVarpId());
                if (newPoints == pointDatum.getLastVarpValue()) {
                    return;
                }
                itemStack.setQuantity(newPoints);
                pointDatum.lastVarpValue = newPoints;
            });
            return true;
        }
        AtomicBoolean updated = new AtomicBoolean(false);
        this.pointData.forEach((itemStack, pointDatum) -> {
            if (pointDatum.getWidget() == null) {
                return;
            }
            updated.set(true);
            this.lastUpdated = System.currentTimeMillis();
            int newPoints = NumberUtils.toInt((String)pointDatum.getWidget().getText(), (int)0);
            if (newPoints == pointDatum.getLastWidgetValue()) {
                return;
            }
            itemStack.setQuantity(newPoints);
            pointDatum.lastWidgetValue = newPoints;
        });
        return updated.get();
    }

    @Override
    public void reset() {
        super.reset();
        this.pointData.forEach((itemStack, mageTrainingArenaPoint) -> mageTrainingArenaPoint.reset());
    }

    public ItemStack getTelekineticPoints() {
        return this.telekineticPoints;
    }

    public ItemStack getGraveyardPoints() {
        return this.graveyardPoints;
    }

    public ItemStack getEnchantmentPoints() {
        return this.enchantmentPoints;
    }

    public ItemStack getAlchemistPoints() {
        return this.alchemistPoints;
    }

    public Map<ItemStack, MageTrainingArenaPoint> getPointData() {
        return this.pointData;
    }

    public Widget getShopWidget() {
        return this.shopWidget;
    }
}

