/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.minigames;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorage;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageType;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.math.NumberUtils;

public class GuardiansOfTheRift
extends MinigamesStorage {
    private final ItemStack elementalEnergy = new ItemStack(556, "Elemental Energy", 0L, 0, 0, true);
    private final ItemStack catalyticEnergy = new ItemStack(564, "Catalytic Energy", 0L, 0, 0, true);
    private final Pattern chatPointsPattern = Pattern.compile("Total elemental energy: <col=ef1020>(\\d+)</col>\\. Total catalytic energy: {2}<col=ef1020>(\\d+)</col>\\.");
    private final Pattern widgetPattern = Pattern.compile("You have (\\d+) catalytic energy and (\\d+) elemental energy\\.");

    GuardiansOfTheRift(DudeWheresMyStuffPlugin plugin) {
        super(MinigamesStorageType.GUARDIANS_OF_THE_RIFT, plugin);
        this.items.add(this.elementalEnergy);
        this.items.add(this.catalyticEnergy);
    }

    @Override
    public boolean onGameTick() {
        Widget widget = this.plugin.getClient().getWidget(229, 1);
        if (widget == null) {
            return false;
        }
        Matcher matcher = this.widgetPattern.matcher(widget.getText().replace(",", ""));
        if (!matcher.find()) {
            return false;
        }
        long lastElementalEnergy = this.elementalEnergy.getQuantity();
        long lastCatalyticEnergy = this.catalyticEnergy.getQuantity();
        this.elementalEnergy.setQuantity(NumberUtils.toInt((String)matcher.group(2), (int)0));
        this.catalyticEnergy.setQuantity(NumberUtils.toInt((String)matcher.group(1), (int)0));
        this.lastUpdated = System.currentTimeMillis();
        return lastElementalEnergy != this.elementalEnergy.getQuantity() || lastCatalyticEnergy != this.catalyticEnergy.getQuantity();
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        if (chatMessage.getMessage().startsWith("You found some loot:")) {
            if (Region.get(WorldPoint.fromLocalInstance((Client)this.plugin.getClient(), (LocalPoint)Objects.requireNonNull(this.plugin.getClient().getLocalPlayer()).getLocalLocation()).getRegionID()) != Region.MG_GUARDIANS_OF_THE_RIFT) {
                return false;
            }
            this.elementalEnergy.setQuantity(this.elementalEnergy.getQuantity() - 1L);
            this.catalyticEnergy.setQuantity(this.catalyticEnergy.getQuantity() - 1L);
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        Matcher matcher = this.chatPointsPattern.matcher(chatMessage.getMessage().replace(",", ""));
        if (!matcher.matches()) {
            return false;
        }
        long lastElementalEnergy = this.elementalEnergy.getQuantity();
        long lastCatalyticEnergy = this.catalyticEnergy.getQuantity();
        this.elementalEnergy.setQuantity(NumberUtils.toInt((String)matcher.group(1), (int)0));
        this.catalyticEnergy.setQuantity(NumberUtils.toInt((String)matcher.group(2), (int)0));
        this.lastUpdated = System.currentTimeMillis();
        return lastElementalEnergy != this.elementalEnergy.getQuantity() || lastCatalyticEnergy != this.catalyticEnergy.getQuantity();
    }

    public ItemStack getElementalEnergy() {
        return this.elementalEnergy;
    }

    public ItemStack getCatalyticEnergy() {
        return this.catalyticEnergy;
    }

    public Pattern getChatPointsPattern() {
        return this.chatPointsPattern;
    }

    public Pattern getWidgetPattern() {
        return this.widgetPattern;
    }
}

