/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grave
extends ExpiringDeathStorage {
    private static final Logger log = LoggerFactory.getLogger(Grave.class);

    Grave(DudeWheresMyStuffPlugin plugin, WorldPoint worldPoint, DeathStorageManager deathStorageManager, List<ItemStack> deathItems) {
        super(plugin, false, worldPoint, deathStorageManager, deathItems, DeathStorageType.GRAVE);
    }

    static Grave load(DudeWheresMyStuffPlugin plugin, DeathStorageManager deathStorageManager, String profileKey, String uuid) {
        Grave grave = new Grave(plugin, null, deathStorageManager, new ArrayList<ItemStack>());
        grave.uuid = UUID.fromString(uuid);
        grave.load(deathStorageManager.getConfigManager(), deathStorageManager.getConfigKey(), profileKey);
        return grave;
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (!this.hasExpired() && (chatMessage.getType() == ChatMessageType.SPAM || chatMessage.getType() == ChatMessageType.GAMEMESSAGE) && Objects.equals(chatMessage.getMessage(), "You successfully retrieved everything from your gravestone.")) {
            this.deathStorageManager.getClientThread().invokeLater(() -> this.deathStorageManager.deleteStorage(this));
        }
        return false;
    }

    @Override
    public boolean onGameTick() {
        if (this.hasExpired()) {
            return false;
        }
        int newExpiryTime = this.plugin.getClient().getVarbitValue(10465);
        if (newExpiryTime <= 0) {
            if (this.expiryTime >= 6) {
                this.deathStorageManager.getClientThread().invokeLater(() -> this.deathStorageManager.deleteStorage(this));
                return false;
            }
            this.expire();
            return true;
        }
        this.expiryTime = newExpiryTime;
        if (this.worldPoint.getX() == 0 && this.worldPoint.getY() == 0 && this.worldPoint.getPlane() == 0) {
            this.findGrave();
        }
        return true;
    }

    private void findGrave() {
        Optional<NPC> graveObject = this.plugin.getClient().getNpcs().stream().filter(n -> n.getId() == 9856).findFirst();
        if (!graveObject.isPresent()) {
            return;
        }
        this.worldPoint = graveObject.get().getWorldLocation();
        this.deathStorageManager.refreshMapPoints();
        SwingUtilities.invokeLater(this::setSubTitle);
    }

    void expire() {
        this.expiredAt = System.currentTimeMillis();
        this.deathStorageManager.getDeathsOffice().getItems().addAll(this.items);
        this.deathStorageManager.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.deathStorageManager.getDeathsOffice()));
        SwingUtilities.invokeLater(() -> {
            if (this.storagePanel == null) {
                return;
            }
            JLabel footerLabel = this.storagePanel.getFooterLabel();
            footerLabel.setIcon(null);
            footerLabel.setToolTipText(null);
        });
    }

    @Override
    public int getTotalLifeInMinutes() {
        return 15;
    }
}

