/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import com.google.common.base.Strings;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffConfig;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class ExpiringDeathStorageTilesOverlay
extends Overlay {
    private final Client client;
    private final DeathStorageManager deathStorageManager;
    private final DudeWheresMyStuffConfig config;

    public ExpiringDeathStorageTilesOverlay(DudeWheresMyStuffConfig config, Client client, DeathStorageManager deathStorageManager) {
        this.config = config;
        this.client = client;
        this.deathStorageManager = deathStorageManager;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    private String getExpiryText(ExpiringDeathStorage expiringDeathStorage) {
        if (expiringDeathStorage.isUseAccountPlayTime() && expiringDeathStorage.getDeathStorageManager().getStartPlayedMinutes() <= 0) {
            return "??";
        }
        int minutesLeft = (int)Math.floor((float)(expiringDeathStorage.getExpiryMs() - System.currentTimeMillis()) / 60000.0f);
        return (Serializable)(minutesLeft > 0 ? Integer.valueOf(minutesLeft) : "<1") + "m";
    }

    public Dimension render(Graphics2D graphics) {
        this.deathStorageManager.getExpiringDeathStorages().filter(storage -> !storage.hasExpired()).forEach(storage -> {
            Color tileColor = storage.getColor();
            if (this.config.flashExpiringDeathpileTiles() && (int)Math.floor((float)(storage.getExpiryMs() - System.currentTimeMillis()) / 60000.0f) <= this.config.deathpileExpiryWarningTime() && this.client.getTickCount() % 2 == 0) {
                tileColor = Color.RED;
            }
            this.drawTile(graphics, storage.getWorldPoint(), tileColor, storage.getName() + " (" + this.getExpiryText((ExpiringDeathStorage)storage) + ")", new BasicStroke(2.0f));
        });
        return null;
    }

    private void drawTile(Graphics2D graphics, WorldPoint point, Color color, @Nullable String label, Stroke borderStroke) {
        Point canvasTextLocation;
        WorldPoint playerLocation = this.client.getLocalPlayer().getWorldLocation();
        if (point.distanceTo(playerLocation) >= 32) {
            return;
        }
        LocalPoint lp = LocalPoint.fromWorld((Client)this.client, (WorldPoint)point);
        if (lp == null) {
            return;
        }
        Polygon poly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)lp);
        if (poly != null) {
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)poly, (Color)color, (Color)new Color(0.0f, 0.0f, 0.0f, 0.3f), (Stroke)borderStroke);
        }
        if (!Strings.isNullOrEmpty((String)label) && (canvasTextLocation = Perspective.getCanvasTextLocation((Client)this.client, (Graphics2D)graphics, (LocalPoint)lp, (String)label, (int)0)) != null) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(canvasTextLocation.getX(), canvasTextLocation.getY() + 20), (String)label, (Color)color);
        }
    }
}

