/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffConfig;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;

public class ExpiringDeathStorageTextOverlay
extends Overlay {
    private final DudeWheresMyStuffConfig config;
    private final DeathStorageManager deathStorageManager;
    private ExpiringDeathStorage storage;
    private String regionName = null;
    private final Client client;

    public ExpiringDeathStorageTextOverlay(DudeWheresMyStuffConfig config, DeathStorageManager deathStorageManager, Client client) {
        this.config = config;
        this.deathStorageManager = deathStorageManager;
        this.client = client;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public void updateSoonestExpiringDeathStorage() {
        ExpiringDeathStorage newStorage = this.client.getVarbitValue(1777) == 2 ? this.deathStorageManager.getSoonestExpiringDeathpile() : this.deathStorageManager.getGrave();
        if (newStorage == this.storage) {
            return;
        }
        this.storage = newStorage;
        if (this.storage != null) {
            Region region = Region.get(this.storage.getWorldPoint().getRegionID());
            this.regionName = region == null ? null : region.getName();
        }
    }

    private boolean shouldRenderOverlay() {
        return this.storage != null && this.config.showDeathpileExpiryText() && (int)Math.floor((float)(this.storage.getExpiryMs() - System.currentTimeMillis()) / 60000.0f) <= this.config.deathpileExpiryWarningTime();
    }

    public Dimension render(Graphics2D graphics) {
        if (this.shouldRenderOverlay()) {
            return this.renderText(graphics);
        }
        return null;
    }

    private Dimension renderText(Graphics2D graphics) {
        Font font = FontManager.getRunescapeFont().deriveFont(0, this.config.deathpileExpiryWarningFontSize());
        graphics.setFont(font);
        String text = "Your " + this.storage.getName().toLowerCase() + " ";
        if (this.regionName != null) {
            text = text + "in " + this.regionName + " ";
        }
        text = text + this.storage.getExpireText().toLowerCase();
        Color textColor = this.client.getTickCount() % 2 == 0 ? Color.RED : Color.WHITE;
        graphics.setColor(textColor);
        FontMetrics metrics = graphics.getFontMetrics(font);
        int textWidth = metrics.stringWidth(text);
        int textHeight = metrics.getHeight();
        graphics.drawString(text, 0, textHeight);
        return new Dimension(textWidth, textHeight);
    }
}

