/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffConfig;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.annotation.Nonnull;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.util.QuantityFormatter;

class ExpiringDeathStorageInfoBox
extends InfoBox {
    private final ExpiringDeathStorage storage;
    private final DudeWheresMyStuffConfig config;
    private final String regionName;
    private final BufferedImage icon;
    private final BufferedImage yellowIcon;
    private final BufferedImage redIcon;
    private boolean imageDirty = false;
    private final Client client;

    public ExpiringDeathStorageInfoBox(@Nonnull DudeWheresMyStuffPlugin plugin, ExpiringDeathStorage storage, int iconId) {
        super(null, (Plugin)plugin);
        this.config = plugin.getConfig();
        this.client = plugin.getClient();
        this.icon = plugin.getItemManager().getImage(iconId);
        this.yellowIcon = ExpiringDeathStorageInfoBox.tintImage(this.icon, new Color(255, 210, 0, 80));
        this.redIcon = ExpiringDeathStorageInfoBox.tintImage(this.icon, new Color(230, 0, 0, 80));
        this.setImage(this.icon);
        this.storage = storage;
        Region region = Region.get(storage.getWorldPoint().getRegionID());
        this.regionName = region == null ? "Unknown" : region.getName();
        this.refreshTooltip();
    }

    private static BufferedImage tintImage(BufferedImage originalImage, Color color) {
        BufferedImage tintedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
        Graphics2D g2d = tintedImage.createGraphics();
        g2d.setColor(color);
        g2d.fillRect(0, 0, tintedImage.getWidth(), tintedImage.getHeight());
        g2d.drawImage((Image)originalImage, 0, 0, null);
        g2d.dispose();
        return tintedImage;
    }

    void refreshTooltip() {
        int minutesLeft;
        String deathpileValue = QuantityFormatter.quantityToStackSize((long)this.storage.getTotalValue());
        this.setTooltip(this.regionName + " " + this.storage.getName().toLowerCase() + " (" + deathpileValue + " gp)");
        if (this.storage.isUseAccountPlayTime() && this.storage.getDeathStorageManager().getStartPlayedMinutes() <= 0) {
            if (this.getImage() != this.yellowIcon) {
                this.setImage(this.yellowIcon);
                this.imageDirty = true;
            }
            return;
        }
        if (this.config.flashExpiringDeathpileInfoboxes() && (minutesLeft = (int)Math.floor((float)(this.storage.getExpiryMs() - System.currentTimeMillis()) / 60000.0f)) <= this.config.deathpileExpiryWarningTime()) {
            if ((this.client.getTickCount() + 1) % 2 == 0) {
                this.setImage(this.redIcon);
            } else {
                this.setImage(this.icon);
            }
            this.imageDirty = true;
            return;
        }
        if (this.getImage() != this.icon) {
            this.setImage(this.icon);
            this.imageDirty = true;
        }
    }

    public String getText() {
        if (this.storage.isUseAccountPlayTime() && this.storage.getDeathStorageManager().getStartPlayedMinutes() <= 0) {
            return "??";
        }
        int minutesLeft = (int)Math.floor((float)(this.storage.getExpiryMs() - System.currentTimeMillis()) / 60000.0f);
        return (Serializable)(minutesLeft > 0 ? Integer.valueOf(minutesLeft) : "<1") + "m";
    }

    public Color getTextColor() {
        return this.storage.getColor();
    }

    public ExpiringDeathStorage getStorage() {
        return this.storage;
    }

    public void setImageDirty(boolean imageDirty) {
        this.imageDirty = imageDirty;
    }

    public boolean isImageDirty() {
        return this.imageDirty;
    }
}

