/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.DurationFormatter;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.DeathWorldMapPoint;
import dev.thource.runelite.dudewheresmystuff.death.Deathpile;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.util.ImageUtil;

public abstract class ExpiringDeathStorage
extends DeathStorage {
    private static final ImageIcon WARNING_ICON = new ImageIcon(ImageUtil.loadImageResource(DudeWheresMyStuffPlugin.class, (String)"warning.png"));
    protected final DeathStorageManager deathStorageManager;
    protected WorldPoint worldPoint;
    protected int expiryTime;
    protected long expiredAt = -1L;
    protected DeathWorldMapPoint worldMapPoint;
    protected Color color = Color.WHITE;
    protected UUID uuid = UUID.randomUUID();
    private boolean useAccountPlayTime;

    ExpiringDeathStorage(DudeWheresMyStuffPlugin plugin, boolean useAccountPlayTime, WorldPoint worldPoint, DeathStorageManager deathStorageManager, List<ItemStack> deathItems, DeathStorageType storageType) {
        super(storageType, plugin);
        this.useAccountPlayTime = useAccountPlayTime;
        this.worldPoint = worldPoint;
        this.deathStorageManager = deathStorageManager;
        this.items.addAll(deathItems);
        int duration = this.getTotalLifeInMinutes();
        duration = this instanceof Deathpile ? (duration -= plugin.getConfig().deathpileContingencyMinutes()) : --duration;
        this.expiryTime = useAccountPlayTime ? deathStorageManager.getPlayedMinutes() + duration : duration * 100;
    }

    @Override
    protected String getConfigKey(String managerConfigKey) {
        return super.getConfigKey(managerConfigKey) + "." + this.uuid;
    }

    @Override
    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = super.getSaveValues();
        saveValues.add(SaveFieldFormatter.format(this.uuid));
        saveValues.add(SaveFieldFormatter.format(this.worldPoint));
        saveValues.add(SaveFieldFormatter.format(this.useAccountPlayTime));
        saveValues.add(SaveFieldFormatter.format(this.expiryTime));
        saveValues.add(SaveFieldFormatter.format(this.expiredAt));
        return saveValues;
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        this.uuid = SaveFieldLoader.loadUUID(values, this.uuid);
        this.worldPoint = SaveFieldLoader.loadWorldPoint(values, this.worldPoint);
        this.useAccountPlayTime = SaveFieldLoader.loadBoolean(values, this.useAccountPlayTime);
        this.expiryTime = SaveFieldLoader.loadInt(values, this.expiryTime);
        this.expiredAt = SaveFieldLoader.loadLong(values, this.expiredAt);
    }

    @Override
    protected void createStoragePanel(StorageManager<?, ?> storageManager) {
        super.createStoragePanel(storageManager);
        assert (this.storagePanel != null);
        this.setSubTitle();
        JLabel footerLabel = this.storagePanel.getFooterLabel();
        if (this.hasExpired()) {
            if (!this.useAccountPlayTime) {
                footerLabel.setIconTextGap(66);
                footerLabel.setHorizontalTextPosition(2);
                footerLabel.setIcon(WARNING_ICON);
                footerLabel.setToolTipText("This " + this.getName().toLowerCase() + " is using tick-based tracking, which means that the timer could be out of sync. To use the more accurate play time based timers, enable cross-client timers in the plugin settings.");
            } else if (this.deathStorageManager.getStartPlayedMinutes() <= 0) {
                footerLabel.setToolTipText("This " + this.getName().toLowerCase() + " is using play time based tracking, but the plugin doesn't know what your current play time is. To update your play time, swap the quest interface to the \"Character summary\" tab (brown star).");
            }
        }
        this.createComponentPopupMenu(storageManager);
    }

    protected void setSubTitle() {
        if (this.storagePanel == null) {
            return;
        }
        Region region = Region.get(this.worldPoint.getRegionID());
        if (region == null) {
            this.storagePanel.setSubTitle("Unknown");
        } else {
            this.storagePanel.setSubTitle(region.getName());
        }
    }

    @Override
    protected void createComponentPopupMenu(StorageManager<?, ?> storageManager) {
        if (this.storagePanel == null) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.storagePanel.setComponentPopupMenu(popupMenu);
        JMenuItem delete = new JMenuItem("Delete " + this.getName());
        delete.addActionListener(e -> {
            boolean confirmed;
            boolean bl = confirmed = this.hasExpired() || DudeWheresMyStuffPlugin.getConfirmation(this.storagePanel, "Are you sure you want to delete this " + this.getName().toLowerCase() + "?\nThis cannot be undone.", "Confirm deletion");
            if (confirmed) {
                this.deathStorageManager.deleteStorage(this);
            }
        });
        popupMenu.add(delete);
        this.createDebugMenuOptions(storageManager, popupMenu);
    }

    private void createDebugMenuOptions(StorageManager<?, ?> storageManager, JPopupMenu popupMenu) {
        if (this.plugin.isDeveloperMode()) {
            JMenu debugMenu = new JMenu("Debug");
            popupMenu.add(debugMenu);
            JMenuItem setExpiresIn = new JMenuItem("Set expires in");
            debugMenu.add(setExpiresIn);
            setExpiresIn.addActionListener(e -> {
                int minutes = 0;
                try {
                    minutes = Integer.parseInt(JOptionPane.showInputDialog("Enter expiry in minutes from now"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (minutes <= 0) {
                    return;
                }
                this.expiryTime = this.useAccountPlayTime ? this.deathStorageManager.getPlayedMinutes() + minutes : minutes * 100;
                this.expiredAt = -1L;
                this.softUpdate();
                storageManager.getStorageTabPanel().reorderStoragePanels();
            });
            JMenuItem expire = new JMenuItem("Expire");
            debugMenu.add(expire);
            expire.addActionListener(e -> {
                this.expiredAt = -1L;
                this.expiryTime = 0;
                this.softUpdate();
                storageManager.getStorageTabPanel().reorderStoragePanels();
            });
        }
    }

    @Override
    public boolean onGameTick() {
        if (this.expiredAt != -1L) {
            return false;
        }
        if (!this.useAccountPlayTime) {
            --this.expiryTime;
            if (this.expiryTime <= 0) {
                this.expiredAt = System.currentTimeMillis();
                SwingUtilities.invokeLater(() -> {
                    if (this.storagePanel == null) {
                        return;
                    }
                    JLabel footerLabel = this.storagePanel.getFooterLabel();
                    footerLabel.setIcon(null);
                    footerLabel.setToolTipText(null);
                });
            }
            return true;
        }
        if (this.deathStorageManager.getStartPlayedMinutes() > 0 && this.deathStorageManager.getPlayedMinutes() >= this.expiryTime) {
            this.expiredAt = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
    }

    String getExpireText() {
        if (this.expiredAt != -1L) {
            return "Expired " + DurationFormatter.format(System.currentTimeMillis() - this.expiredAt) + " ago";
        }
        if (this.useAccountPlayTime && this.deathStorageManager.getStartPlayedMinutes() <= 0) {
            return "Waiting for play time";
        }
        return "Expires in " + DurationFormatter.format(this.getExpiryMs() - System.currentTimeMillis());
    }

    public abstract int getTotalLifeInMinutes();

    public long getExpiryMs() {
        if (this.expiredAt != -1L) {
            return this.expiredAt;
        }
        if (!this.useAccountPlayTime) {
            return System.currentTimeMillis() + (long)this.expiryTime * 600L;
        }
        if (this.deathStorageManager.getStartPlayedMinutes() <= 0) {
            return System.currentTimeMillis() + (long)this.getTotalLifeInMinutes() * 60000L;
        }
        int minutesLeft = this.expiryTime - this.deathStorageManager.getPlayedMinutes();
        if (this.deathStorageManager.isPreviewManager()) {
            return System.currentTimeMillis() + (long)minutesLeft * 60000L;
        }
        return System.currentTimeMillis() + (long)minutesLeft * 60000L - (System.currentTimeMillis() - this.deathStorageManager.startMs) % 60000L;
    }

    public boolean hasExpired() {
        return this.getExpiryMs() < System.currentTimeMillis();
    }

    @Override
    public void softUpdate() {
        if (this.storagePanel == null) {
            return;
        }
        this.storagePanel.setFooterText(this.getExpireText());
    }

    @Override
    public boolean isWithdrawable() {
        return super.isWithdrawable() && !this.hasExpired();
    }

    public DeathStorageManager getDeathStorageManager() {
        return this.deathStorageManager;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public int getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(int expiryTime) {
        this.expiryTime = expiryTime;
    }

    public DeathWorldMapPoint getWorldMapPoint() {
        return this.worldMapPoint;
    }

    public void setWorldMapPoint(DeathWorldMapPoint worldMapPoint) {
        this.worldMapPoint = worldMapPoint;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isUseAccountPlayTime() {
        return this.useAccountPlayTime;
    }
}

