/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.runelite.api.coords.WorldPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deathpile
extends ExpiringDeathStorage {
    private static final Logger log = LoggerFactory.getLogger(Deathpile.class);

    Deathpile(DudeWheresMyStuffPlugin plugin, boolean useAccountPlayTime, WorldPoint worldPoint, DeathStorageManager deathStorageManager, List<ItemStack> deathItems) {
        super(plugin, useAccountPlayTime, worldPoint, deathStorageManager, deathItems, DeathStorageType.DEATHPILE);
        this.color = this.generateColor();
    }

    static Deathpile load(DudeWheresMyStuffPlugin plugin, DeathStorageManager deathStorageManager, String profileKey, String uuid) {
        Deathpile deathpile = new Deathpile(plugin, true, null, deathStorageManager, new ArrayList<ItemStack>());
        deathpile.uuid = UUID.fromString(uuid);
        deathpile.load(deathStorageManager.getConfigManager(), deathStorageManager.getConfigKey(), profileKey);
        return deathpile;
    }

    private Color generateColor() {
        if (this.worldPoint == null) {
            return Color.WHITE;
        }
        Random rand = new Random((long)this.worldPoint.getX() * 200L + (long)this.worldPoint.getY() * 354L + (long)this.worldPoint.getPlane() * 42L);
        float saturation = 0.7f + rand.nextFloat() * 0.3f;
        float hue = rand.nextFloat();
        return Color.getHSBColor(hue, saturation, 0.8f);
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        this.color = this.generateColor();
    }

    @Override
    public int getTotalLifeInMinutes() {
        return 60;
    }
}

