/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.DurationFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.DeathbankType;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deathbank
extends DeathStorage {
    private static final Logger log = LoggerFactory.getLogger(Deathbank.class);
    protected UUID uuid = UUID.randomUUID();
    private boolean locked = false;
    private long lostAt = -1L;
    private DeathbankType deathbankType;
    private DeathStorageManager deathStorageManager;

    Deathbank(DeathbankType deathbankType, DudeWheresMyStuffPlugin plugin, DeathStorageManager deathStorageManager) {
        super(DeathStorageType.DEATHBANK, plugin);
        this.deathbankType = deathbankType;
        this.deathStorageManager = deathStorageManager;
    }

    static Deathbank load(DudeWheresMyStuffPlugin plugin, DeathStorageManager deathStorageManager, String profileKey, String uuid) {
        Deathbank deathbank = new Deathbank(DeathbankType.UNKNOWN, plugin, deathStorageManager);
        deathbank.uuid = UUID.fromString(uuid);
        deathbank.load(deathStorageManager.getConfigManager(), deathStorageManager.getConfigKey(), profileKey);
        if (deathbank.getItems().isEmpty()) {
            deathbank.deleteData(deathStorageManager);
            return null;
        }
        return deathbank;
    }

    @Override
    protected String getConfigKey(String managerConfigKey) {
        return super.getConfigKey(managerConfigKey) + "." + this.uuid;
    }

    @Override
    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = super.getSaveValues();
        saveValues.add(SaveFieldFormatter.format(this.uuid));
        saveValues.add(SaveFieldFormatter.format(this.locked));
        saveValues.add(SaveFieldFormatter.format(this.lostAt));
        saveValues.add(SaveFieldFormatter.format(this.deathbankType));
        return saveValues;
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        this.uuid = SaveFieldLoader.loadUUID(values, this.uuid);
        this.locked = SaveFieldLoader.loadBoolean(values, this.locked);
        this.lostAt = SaveFieldLoader.loadLong(values, this.lostAt);
        this.deathbankType = SaveFieldLoader.loadDeathbankType(values, this.deathbankType);
    }

    @Override
    protected void createStoragePanel(StorageManager<?, ?> storageManager) {
        super.createStoragePanel(storageManager);
        assert (this.storagePanel != null);
        this.storagePanel.setTitle(this.deathbankType.getName());
        this.storagePanel.setSubTitle(this.locked ? "Locked" : "Unlocked");
        this.createComponentPopupMenu(storageManager);
    }

    @Override
    protected void createComponentPopupMenu(StorageManager<?, ?> storageManager) {
        if (this.storagePanel == null) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.storagePanel.setComponentPopupMenu(popupMenu);
        JMenuItem clearDeathbank = new JMenuItem("Delete Deathbank");
        clearDeathbank.addActionListener(e -> {
            boolean confirmed;
            boolean bl = confirmed = this.lostAt != -1L || DudeWheresMyStuffPlugin.getConfirmation(this.storagePanel, "Are you sure you want to delete this deathbank?\nThis cannot be undone.", "Confirm deletion");
            if (confirmed) {
                if (this == this.deathStorageManager.getDeathbank()) {
                    this.deathStorageManager.clearDeathbank(false);
                } else {
                    this.deathStorageManager.getStorages().remove(this);
                    this.deleteData(this.deathStorageManager);
                }
                this.deathStorageManager.getStorageTabPanel().reorderStoragePanels();
            }
        });
        popupMenu.add(clearDeathbank);
    }

    void setLocked(boolean locked) {
        this.locked = locked;
        SwingUtilities.invokeLater(() -> {
            if (this.storagePanel != null) {
                this.storagePanel.setSubTitle(locked ? "Locked" : "Unlocked");
            }
        });
    }

    @Override
    public void reset() {
    }

    @Override
    public void softUpdate() {
        if (this.storagePanel != null && this.lostAt != -1L) {
            long timeSinceLost = System.currentTimeMillis() - this.lostAt;
            this.storagePanel.setFooterText("Lost " + DurationFormatter.format(Math.abs(timeSinceLost)) + " ago");
            return;
        }
        super.softUpdate();
    }

    public boolean isActive() {
        return this.lostAt == -1L;
    }

    @Override
    public boolean isWithdrawable() {
        return super.isWithdrawable() && this.isActive();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public DeathbankType getDeathbankType() {
        return this.deathbankType;
    }

    public DeathStorageManager getDeathStorageManager() {
        return this.deathStorageManager;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setLostAt(long lostAt) {
        this.lostAt = lostAt;
    }

    public void setDeathbankType(DeathbankType deathbankType) {
        this.deathbankType = deathbankType;
    }

    public void setDeathStorageManager(DeathStorageManager deathStorageManager) {
        this.deathStorageManager = deathStorageManager;
    }

    public long getLostAt() {
        return this.lostAt;
    }
}

