/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.util.ImageUtil;

class DeathWorldMapPoint
extends WorldMapPoint {
    private final ItemManager itemManager;
    private final BufferedImage worldmapHintArrow;
    private final Point worldmapHintArrowPoint;
    private BufferedImage mapArrow;

    DeathWorldMapPoint(WorldPoint worldPoint, ItemManager itemManager, int index) {
        super(worldPoint, null);
        this.itemManager = itemManager;
        this.worldmapHintArrow = new BufferedImage(this.getMapArrow().getWidth(), this.getMapArrow().getHeight(), 2);
        Graphics graphics = this.worldmapHintArrow.getGraphics();
        graphics.drawImage(this.getMapArrow(), 0, 0, null);
        graphics.drawImage((Image)itemManager.getImage(526), 0, 0, null);
        this.worldmapHintArrowPoint = new Point(this.worldmapHintArrow.getWidth() / 2, this.worldmapHintArrow.getHeight());
        this.setSnapToEdge(true);
        this.setJumpOnClick(true);
        this.setImage(this.worldmapHintArrow);
        this.setImagePoint(this.worldmapHintArrowPoint);
        this.setTooltip("Deathpile");
        this.setName("Deathpile " + index);
    }

    BufferedImage getMapArrow() {
        if (this.mapArrow != null) {
            return this.mapArrow;
        }
        this.mapArrow = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/util/clue_arrow.png");
        return this.mapArrow;
    }

    public void onEdgeSnap() {
        this.setImage((BufferedImage)this.itemManager.getImage(526));
        this.setImagePoint(null);
        this.setTooltip(null);
    }

    public void onEdgeUnsnap() {
        this.setImage(this.worldmapHintArrow);
        this.setImagePoint(this.worldmapHintArrowPoint);
        this.setTooltip("Deathpile");
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

