/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.StorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.death.DeathItems;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.Deathbank;
import dev.thource.runelite.dudewheresmystuff.death.DeathsOffice;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathStorageTabPanel
extends StorageTabPanel<DeathStorageType, DeathStorage, DeathStorageManager> {
    private static final Logger log = LoggerFactory.getLogger(DeathStorageTabPanel.class);

    public DeathStorageTabPanel(DudeWheresMyStuffPlugin plugin, DeathStorageManager storageManager) {
        super(plugin, storageManager);
    }

    @Override
    protected Comparator<DeathStorage> getStorageSorter() {
        return Comparator.comparingLong(s -> {
            if (s instanceof ExpiringDeathStorage) {
                ExpiringDeathStorage storage = (ExpiringDeathStorage)s;
                if (storage.hasExpired()) {
                    return Long.MAX_VALUE - storage.getExpiryMs();
                }
                return Long.MIN_VALUE + storage.getExpiryMs();
            }
            if (s instanceof DeathItems || s instanceof DeathsOffice) {
                return Long.MIN_VALUE;
            }
            Deathbank deathbank = (Deathbank)s;
            if (deathbank.getLostAt() != -1L) {
                return Long.MAX_VALUE - deathbank.getLostAt();
            }
            return -9223372036854775807L;
        });
    }
}

