/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.ItemStackUtils;
import dev.thource.runelite.dudewheresmystuff.Region;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageType;
import dev.thource.runelite.dudewheresmystuff.death.CheckPlayTimeInfoBox;
import dev.thource.runelite.dudewheresmystuff.death.DeathItems;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import dev.thource.runelite.dudewheresmystuff.death.DeathWorldMapPoint;
import dev.thource.runelite.dudewheresmystuff.death.Deathbank;
import dev.thource.runelite.dudewheresmystuff.death.DeathbankInfoBox;
import dev.thource.runelite.dudewheresmystuff.death.DeathbankType;
import dev.thource.runelite.dudewheresmystuff.death.Deathpile;
import dev.thource.runelite.dudewheresmystuff.death.DeathpileInfoBox;
import dev.thource.runelite.dudewheresmystuff.death.DeathsOffice;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorageInfoBox;
import dev.thource.runelite.dudewheresmystuff.death.Grave;
import dev.thource.runelite.dudewheresmystuff.death.GraveInfoBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.Quest;
import net.runelite.api.QuestState;
import net.runelite.api.Skill;
import net.runelite.api.TileItem;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.widgets.Widget;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.worldmap.WorldMapPoint;
import net.runelite.client.ui.overlay.worldmap.WorldMapPointManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathStorageManager
extends StorageManager<DeathStorageType, DeathStorage> {
    private static final Logger log = LoggerFactory.getLogger(DeathStorageManager.class);
    private static final Set<Integer> RESPAWN_REGIONS = ImmutableSet.of((Object)6457, (Object)12850, (Object)11828, (Object)12342, (Object)11062, (Object)13150, (Object[])new Integer[]{12894, 14642, 12172, 12633});
    private final CheckPlayTimeInfoBox playTimeInfoBox;
    private final List<ExpiringDeathStorageInfoBox> expiringDeathStorageInfoBoxes;
    private final DeathsOffice deathsOffice;
    long startMs;
    @Nullable
    private Deathbank deathbank;
    @Nullable
    private Grave grave;
    private CarryableStorageManager carryableStorageManager;
    private CoinsStorageManager coinsStorageManager;
    @Inject
    private WorldMapPointManager worldMapPointManager;
    private int startPlayedMinutes;
    private boolean dying;
    private WorldPoint deathLocation;
    private List<ItemStack> deathItems;
    private Item[] oldInventoryItems;
    private DeathbankInfoBox deathbankInfoBox;

    @Inject
    private DeathStorageManager(DudeWheresMyStuffPlugin plugin) {
        super(plugin);
        this.playTimeInfoBox = new CheckPlayTimeInfoBox(this.plugin);
        this.expiringDeathStorageInfoBoxes = new ArrayList<ExpiringDeathStorageInfoBox>();
        this.startMs = 0L;
        this.deathbank = null;
        this.grave = null;
        this.startPlayedMinutes = -1;
        this.playTimeInfoBox.setTooltip("Navigate to the quest tab and swap to</br>the Character Summary tab (brown star) to</br>track cross-client deathpiles.");
        this.storages.add(new DeathItems(plugin, this));
        this.deathsOffice = new DeathsOffice(plugin, this);
        this.storages.add(this.deathsOffice);
    }

    @Override
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (!this.enabled) {
            return;
        }
        if (itemContainerChanged.getContainerId() == InventoryID.INVENTORY.getId()) {
            if (this.updateInventoryItems(itemContainerChanged.getItemContainer().getItems())) {
                this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.deathbank));
            }
        } else if (itemContainerChanged.getContainerId() == 525) {
            if (this.client.getWidget(672, 0) == null) {
                this.updateDeathbankItems(itemContainerChanged.getItemContainer().getItems());
                SwingUtilities.invokeLater(() -> this.plugin.getClientThread().invoke(() -> this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.deathbank))));
            } else {
                this.updateGraveItems(itemContainerChanged.getItemContainer().getItems());
                SwingUtilities.invokeLater(() -> this.plugin.getClientThread().invoke(() -> this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.grave))));
            }
        }
    }

    @Override
    public void onVarbitChanged() {
        if (this.grave == null) {
            if (this.client.getVarbitValue(10465) > 0 && this.client.getBoostedSkillLevel(Skill.HITPOINTS) > 0) {
                this.createMysteryGrave();
            }
            return;
        }
        if (this.grave.hasExpired()) {
            this.grave = null;
        }
    }

    private void updateGraveItems(Item[] items) {
        if (this.grave == null) {
            this.createMysteryGrave();
        }
        this.grave.getItems().clear();
        for (Item item : items) {
            if (item.getId() == -1) continue;
            this.grave.getItems().add(new ItemStack(item.getId(), item.getQuantity(), this.plugin));
        }
    }

    private void updateDeathbankItems(Item[] items) {
        int deathbankVarp = this.client.getVarpValue(261);
        DeathbankType deathbankType = Arrays.stream(DeathbankType.values()).filter(s -> s.getDeathBankLockedState() == deathbankVarp || s.getDeathBankUnlockedState() == deathbankVarp).findFirst().orElse(DeathbankType.UNKNOWN);
        if (this.deathbank == null) {
            this.deathbank = new Deathbank(deathbankType, this.plugin, this);
            this.storages.add(this.deathbank);
            SwingUtilities.invokeLater(() -> this.deathbank.createStoragePanel(this));
        } else {
            this.deathbank.setDeathbankType(deathbankType);
            this.deathbank.getItems().clear();
        }
        this.deathbank.setLocked(deathbankType.getDeathBankLockedState() == deathbankVarp);
        this.deathbank.setLastUpdated(System.currentTimeMillis());
        for (Item item : items) {
            if (item.getId() == -1) continue;
            this.deathbank.getItems().add(new ItemStack(item.getId(), item.getQuantity(), this.plugin));
        }
    }

    private boolean updateInventoryItems(Item[] items) {
        boolean updated = false;
        if (this.oldInventoryItems != null && this.client.getLocalPlayer() != null && this.deathbank != null && this.deathbank.getDeathbankType() == DeathbankType.ZULRAH && Region.get(this.client.getLocalPlayer().getWorldLocation().getRegionID()) == Region.CITY_ZULANDRA) {
            List<ItemStack> inventoryItemsList = Arrays.stream(items).map(i -> new ItemStack(i.getId(), "", i.getQuantity(), 0, 0, true)).collect(Collectors.toList());
            this.removeItemsFromList(inventoryItemsList, this.oldInventoryItems);
            this.removeItemsFromList(this.deathbank.getItems(), inventoryItemsList);
            if (!inventoryItemsList.isEmpty()) {
                this.deathbank.setLastUpdated(System.currentTimeMillis());
                updated = true;
            }
            if (this.deathbank.getItems().isEmpty()) {
                this.clearDeathbank(false);
            }
        }
        this.oldInventoryItems = items;
        return updated;
    }

    private void removeItemsFromList(List<ItemStack> listToRemoveFrom, List<ItemStack> itemsToRemove) {
        for (ItemStack itemToRemove : itemsToRemove) {
            ItemStackUtils.removeItemStack(listToRemoveFrom, itemToRemove, false);
        }
    }

    private void removeItemsFromList(List<ItemStack> listToRemoveFrom, Item[] itemsToRemove) {
        for (Item item : itemsToRemove) {
            ItemStackUtils.removeItemStack(listToRemoveFrom, new ItemStack(item.getId(), "", item.getQuantity(), 0, 0, true), false);
        }
    }

    void clearDeathbank(boolean wasLost) {
        if (this.deathbank != null) {
            if (wasLost) {
                this.deathbank.setLostAt(System.currentTimeMillis());
            } else {
                this.storages.remove(this.deathbank);
                this.deathbank.deleteData(this);
            }
        }
        this.deathbank = null;
    }

    @Override
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.startPlayedMinutes = -1;
            this.startMs = 0L;
        }
    }

    @Override
    public void onGameTick() {
        super.onGameTick();
        this.updateStartPlayedMinutes();
        if ((this.deathbank != null && this.checkIfDeathbankWindowIsEmpty()) | this.processDeath() | this.checkItemsLostOnDeathWindow()) {
            SwingUtilities.invokeLater(() -> this.plugin.getClientThread().invoke(() -> this.updateStorages(this.storages)));
        }
        this.refreshInfoBoxes();
        this.updateWorldMapPoints();
    }

    public Deathpile getSoonestExpiringDeathpile() {
        return this.getDeathpiles().filter(deathpile -> !deathpile.hasExpired()).min(Comparator.comparing(ExpiringDeathStorage::getExpiryMs)).orElse(null);
    }

    private boolean checkIfDeathbankWindowIsEmpty() {
        Widget itemWindow = this.client.getWidget(602, 3);
        if (itemWindow != null && this.client.getVarpValue(261) == -1) {
            this.clearDeathbank(false);
            return true;
        }
        return false;
    }

    private void updateStartPlayedMinutes() {
        Integer savedPlayedMinutes;
        int playedMinutes = this.client.getVarcIntValue(526);
        if (playedMinutes != this.startPlayedMinutes) {
            if (this.startPlayedMinutes == -1) {
                this.refreshMapPoints();
            }
            SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
            this.startPlayedMinutes = playedMinutes;
            this.startMs = System.currentTimeMillis();
            if (this.startPlayedMinutes > 0) {
                this.getExpiringDeathStorages().filter(ExpiringDeathStorage::isUseAccountPlayTime).filter(storage -> storage.getStoragePanel() != null).forEach(storage -> storage.getStoragePanel().getFooterLabel().setToolTipText(null));
            }
        }
        if (this.startPlayedMinutes > 0 && ((savedPlayedMinutes = (Integer)this.configManager.getRSProfileConfiguration("dudewheresmystuff", "minutesPlayed", Integer.TYPE)) == null || savedPlayedMinutes.intValue() != this.getPlayedMinutes())) {
            this.configManager.setRSProfileConfiguration("dudewheresmystuff", "minutesPlayed", (Object)this.getPlayedMinutes());
        }
    }

    Stream<Deathpile> getDeathpiles() {
        return this.storages.stream().filter(Deathpile.class::isInstance).map(Deathpile.class::cast);
    }

    Stream<Grave> getGraves() {
        return this.storages.stream().filter(Grave.class::isInstance).map(Grave.class::cast);
    }

    Stream<ExpiringDeathStorage> getExpiringDeathStorages() {
        return this.storages.stream().filter(ExpiringDeathStorage.class::isInstance).map(ExpiringDeathStorage.class::cast);
    }

    public void refreshInfoBoxes() {
        this.refreshCheckPlayTimeInfoBox();
        this.refreshDeathbankInfoBox();
        this.refreshExpiringDeathStorageInfoBoxes();
    }

    private void pruneExpiringDeathStorageInfoBoxes(List<ExpiringDeathStorage> activeExpiringDeathStorages, InfoBoxManager infoBoxManager, List<InfoBox> currentInfoBoxes) {
        ListIterator<ExpiringDeathStorageInfoBox> iterator = this.expiringDeathStorageInfoBoxes.listIterator();
        while (iterator.hasNext()) {
            ExpiringDeathStorageInfoBox infoBox = iterator.next();
            if (activeExpiringDeathStorages.contains(infoBox.getStorage())) continue;
            if (currentInfoBoxes.contains((Object)infoBox)) {
                infoBoxManager.removeInfoBox((InfoBox)infoBox);
            }
            iterator.remove();
        }
    }

    private void refreshInfoBoxImage(ExpiringDeathStorageInfoBox infoBox) {
        if (!infoBox.isImageDirty()) {
            return;
        }
        InfoBoxManager infoBoxManager = this.plugin.getInfoBoxManager();
        List currentInfoBoxes = infoBoxManager.getInfoBoxes();
        if (currentInfoBoxes.contains((Object)infoBox)) {
            infoBoxManager.updateInfoBoxImage((InfoBox)infoBox);
        }
        infoBox.setImageDirty(false);
    }

    private void refreshExpiringDeathStorageInfoBoxes() {
        InfoBoxManager infoBoxManager = this.plugin.getInfoBoxManager();
        List currentInfoBoxes = infoBoxManager.getInfoBoxes();
        List<ExpiringDeathStorage> activeExpiringDeathStorages = this.getExpiringDeathStorages().filter(storage -> !storage.hasExpired()).collect(Collectors.toList());
        this.pruneExpiringDeathStorageInfoBoxes(activeExpiringDeathStorages, infoBoxManager, currentInfoBoxes);
        activeExpiringDeathStorages.forEach(storage -> {
            if (this.expiringDeathStorageInfoBoxes.stream().noneMatch(infoBox -> infoBox.getStorage() == storage)) {
                ExpiringDeathStorageInfoBox infoBox2 = storage instanceof Deathpile ? new DeathpileInfoBox(this.plugin, (Deathpile)storage) : new GraveInfoBox(this.plugin, (Grave)storage);
                this.expiringDeathStorageInfoBoxes.add(infoBox2);
            }
        });
        for (ExpiringDeathStorageInfoBox infoBox : this.expiringDeathStorageInfoBoxes) {
            if (this.plugin.getConfig().deathpileInfoBox()) {
                infoBox.refreshTooltip();
                this.refreshInfoBoxImage(infoBox);
                if (currentInfoBoxes.contains((Object)infoBox)) continue;
                infoBoxManager.addInfoBox((InfoBox)infoBox);
                continue;
            }
            if (!currentInfoBoxes.contains((Object)infoBox)) continue;
            infoBoxManager.removeInfoBox((InfoBox)infoBox);
        }
    }

    private void refreshDeathbankInfoBox() {
        boolean showInfoBox = this.deathbank != null && this.plugin.getConfig().deathbankInfoBox();
        boolean hasDeathbankChanged = showInfoBox && this.deathbankInfoBox == null || this.deathbankInfoBox != null && this.deathbankInfoBox.getDeathbank() != this.deathbank;
        List infoBoxes = this.plugin.getInfoBoxManager().getInfoBoxes();
        if (this.deathbankInfoBox != null && (!showInfoBox || hasDeathbankChanged) && infoBoxes.contains((Object)this.deathbankInfoBox)) {
            this.plugin.getInfoBoxManager().removeInfoBox((InfoBox)this.deathbankInfoBox);
        }
        if (hasDeathbankChanged) {
            DeathbankInfoBox deathbankInfoBox = this.deathbankInfoBox = this.deathbank == null ? null : new DeathbankInfoBox(this.plugin, this.deathbank);
        }
        if (showInfoBox && !infoBoxes.contains((Object)this.deathbankInfoBox)) {
            this.plugin.getInfoBoxManager().addInfoBox((InfoBox)this.deathbankInfoBox);
        }
    }

    private boolean doesAnyActiveExpiringDeathStorageUseAccountPlayTime() {
        return this.getExpiringDeathStorages().filter(storage -> !storage.hasExpired()).anyMatch(ExpiringDeathStorage::isUseAccountPlayTime);
    }

    private void refreshCheckPlayTimeInfoBox() {
        boolean showInfoBox = this.startPlayedMinutes <= 0 && (this.plugin.getConfig().deathpilesUseAccountPlayTime() || this.doesAnyActiveExpiringDeathStorageUseAccountPlayTime());
        boolean isAdded = this.plugin.getInfoBoxManager().getInfoBoxes().contains((Object)this.playTimeInfoBox);
        if (!showInfoBox && isAdded) {
            this.plugin.getInfoBoxManager().removeInfoBox((InfoBox)this.playTimeInfoBox);
        } else if (showInfoBox && !isAdded) {
            this.plugin.getInfoBoxManager().addInfoBox((InfoBox)this.playTimeInfoBox);
        }
    }

    @Override
    public void onChatMessage(ChatMessage chatMessage) {
        super.onChatMessage(chatMessage);
        if (chatMessage.getType() != ChatMessageType.GAMEMESSAGE || this.deathbank != null) {
            return;
        }
        String message = Text.removeTags((String)chatMessage.getMessage());
        if (!message.startsWith("You have items stored in an item retrieval service.")) {
            return;
        }
        String finalMessage = message.replace(" ", "");
        DeathbankType deathbankType = Arrays.stream(DeathbankType.values()).filter(type -> type.getDeathWindowLocationText() != null).filter(type -> finalMessage.contains(type.getDeathWindowLocationText())).findFirst().orElse(DeathbankType.UNKNOWN);
        if (deathbankType == DeathbankType.UNKNOWN && this.client.getVarbitValue(1777) != 2) {
            this.createMysteryGrave();
            this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.grave));
            return;
        }
        this.createMysteryDeathbank(deathbankType);
        this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.deathbank));
    }

    private boolean checkItemsLostOnDeathWindow() {
        String deathbankText;
        Widget textWidget;
        Widget deathbankTextWidget;
        if (this.deathbank == null && (deathbankTextWidget = this.client.getWidget(4, 3)) != null && (textWidget = deathbankTextWidget.getChild(3)) != null && (deathbankText = Text.removeTags((String)textWidget.getText()).replace(" ", "")).contains("theywillbedeleted")) {
            DeathbankType type = Arrays.stream(DeathbankType.values()).filter(t -> t.getDeathWindowLocationText() != null && deathbankText.contains(t.getDeathWindowLocationText())).findFirst().orElse(DeathbankType.UNKNOWN);
            this.createMysteryDeathbank(type);
            return true;
        }
        return false;
    }

    private void createMysteryGrave() {
        if (this.grave != null) {
            return;
        }
        this.grave = new Grave(this.plugin, new WorldPoint(0, 0, 0), this, new ArrayList<ItemStack>());
        this.storages.add(this.grave);
        this.grave.getItems().add(new ItemStack(6199, 1L, this.plugin));
        SwingUtilities.invokeLater(() -> {
            this.grave.createStoragePanel(this);
            this.plugin.getClientThread().invoke(() -> this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.grave)));
        });
    }

    private void createMysteryDeathbank(DeathbankType type) {
        this.deathbank = new Deathbank(type, this.plugin, this);
        this.storages.add(this.deathbank);
        this.deathbank.setLastUpdated(System.currentTimeMillis());
        this.deathbank.setLocked(type != DeathbankType.ZULRAH || this.client.getVarbitValue(1777) != 2);
        this.deathbank.getItems().add(new ItemStack(6199, 1L, this.plugin));
        SwingUtilities.invokeLater(() -> {
            this.deathbank.createStoragePanel(this);
            this.plugin.getClientThread().invoke(() -> this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.deathbank)));
        });
    }

    @Override
    protected void updateStorages(List<? extends DeathStorage> storages) {
        if (!storages.isEmpty()) {
            storages.forEach(storage -> {
                if (storage.getStoragePanel() != null) {
                    storage.getStoragePanel().refreshItems();
                }
            });
            SwingUtilities.invokeLater(() -> storages.forEach(storage -> {
                if (storage.getStoragePanel() != null) {
                    storage.getStoragePanel().update();
                }
            }));
            SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
        }
    }

    private void updateWorldMapPoints() {
        if (this.storages.stream().filter(Deathpile.class::isInstance).map(Deathpile.class::cast).anyMatch(deathpile -> {
            if (deathpile.worldMapPoint == null) {
                return !deathpile.hasExpired();
            }
            if (deathpile.hasExpired()) {
                return true;
            }
            if (deathpile.worldMapPoint.getTooltip() == null) {
                return false;
            }
            deathpile.worldMapPoint.setTooltip("Deathpile (" + deathpile.getExpireText() + ")");
            return false;
        })) {
            this.refreshMapPoints();
        }
    }

    private boolean processDeath() {
        if (this.client.getLocalPlayer() == null || !this.dying || this.client.getBoostedSkillLevel(Skill.HITPOINTS) < 10) {
            return false;
        }
        boolean updated = false;
        Region deathRegion = Region.get(this.deathLocation.getRegionID());
        if (!RESPAWN_REGIONS.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            if (deathRegion == Region.RAIDS_THEATRE_OF_BLOOD) {
                return false;
            }
            log.info("Died, but did not respawn in a known respawn location: " + this.client.getLocalPlayer().getWorldLocation().getRegionID());
        } else if (deathRegion != Region.REGION_POH) {
            updated = true;
            this.registerDeath(deathRegion);
        }
        this.dying = false;
        this.deathLocation = null;
        this.deathItems = null;
        return updated;
    }

    private void registerDeath(Region deathRegion) {
        this.clearDeathbank(true);
        if (deathRegion == Region.MG_CORRUPTED_GAUNTLET || deathRegion == Region.MG_GAUNTLET) {
            return;
        }
        this.clearCarryableStorage();
        Stream.of(InventoryID.INVENTORY, InventoryID.EQUIPMENT).map(id -> this.client.getItemContainer(id)).filter(Objects::nonNull).forEach(i -> this.removeItemsFromList(this.deathItems, i.getItems()));
        Optional<DeathbankType> deathbankType = this.getDeathbankType(deathRegion);
        if (deathbankType.isPresent()) {
            this.deathbank = new Deathbank(deathbankType.get(), this.plugin, this);
            this.storages.add(this.deathbank);
            SwingUtilities.invokeLater(() -> this.deathbank.createStoragePanel(this));
            this.deathbank.setLastUpdated(System.currentTimeMillis());
            this.deathbank.setLocked(deathbankType.get() != DeathbankType.ZULRAH || this.client.getVarbitValue(1777) != 2);
            this.deathbank.getItems().addAll(this.deathItems);
        } else if (this.client.getVarbitValue(1777) == 2) {
            this.createDeathpile(this.deathLocation, this.deathItems);
        } else {
            this.createGrave(this.deathLocation, this.deathItems);
        }
        this.refreshMapPoints();
    }

    private void clearCarryableStorage() {
        this.coinsStorageManager.getStorages().stream().filter(s -> s.getType() == CoinsStorageType.LOOTING_BAG).forEach(s -> {
            s.getCoinStack().setQuantity(0L);
            if (s.getStoragePanel() != null) {
                s.getStoragePanel().refreshItems();
                SwingUtilities.invokeLater(() -> s.getStoragePanel().update());
            }
        });
        SwingUtilities.invokeLater(this.coinsStorageManager.getStorageTabPanel()::reorderStoragePanels);
        this.carryableStorageManager.getStorages().stream().filter(s -> s.getType() == CarryableStorageType.LOOTING_BAG || ((CarryableStorageType)s.getType()).getEmptyOnDeathVarbit() != -1 && this.client.getVarbitValue(((CarryableStorageType)s.getType()).getEmptyOnDeathVarbit()) == 1).forEach(s -> {
            s.getItems().clear();
            if (s.getStoragePanel() != null) {
                s.getStoragePanel().refreshItems();
                SwingUtilities.invokeLater(() -> s.getStoragePanel().update());
            }
        });
        SwingUtilities.invokeLater(this.carryableStorageManager.getStorageTabPanel()::reorderStoragePanels);
    }

    void createDeathpile(WorldPoint location, List<ItemStack> items) {
        boolean useAccountPlayTime = this.deathpilesUseAccountPlayTime();
        Deathpile deathpile = new Deathpile(this.plugin, useAccountPlayTime, location, this, items);
        SwingUtilities.invokeLater(() -> deathpile.createStoragePanel(this));
        this.storages.add(deathpile);
    }

    void createGrave(WorldPoint location, List<ItemStack> items) {
        if (this.grave != null) {
            this.grave.getItems().addAll(items);
            this.updateStorages((List<? extends DeathStorage>)Collections.singletonList(this.grave));
            return;
        }
        this.grave = new Grave(this.plugin, location, this, items);
        SwingUtilities.invokeLater(() -> this.grave.createStoragePanel(this));
        this.storages.add(this.grave);
    }

    private Optional<DeathbankType> getDeathbankType(Region deathRegion) {
        if (deathRegion == null) {
            return Optional.empty();
        }
        if (deathRegion == Region.BOSS_VORKATH) {
            return Optional.of(Quest.DRAGON_SLAYER_II.getState(this.client) == QuestState.IN_PROGRESS ? DeathbankType.QUEST_DS2 : DeathbankType.VORKATH);
        }
        if (deathRegion == Region.BOSS_NIGHTMARE) {
            return Optional.of(DeathbankType.NIGHTMARE);
        }
        return Arrays.stream(DeathbankType.values()).filter(s -> s.getRegion() == deathRegion).findFirst();
    }

    @Override
    public void onActorDeath(ActorDeath actorDeath) {
        if (this.client.getLocalPlayer() == null || actorDeath.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        WorldPoint location = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation());
        List items = this.getDeathItems().stream().filter(itemStack -> itemStack.getId() != -1).collect(Collectors.toList());
        if (items.isEmpty()) {
            return;
        }
        this.dying = true;
        this.deathLocation = location;
        this.deathItems = items;
    }

    @Override
    public void onItemDespawned(ItemDespawned itemDespawned) {
        WorldPoint worldPoint = itemDespawned.getTile().getWorldLocation();
        if (worldPoint.distanceTo(this.plugin.getClient().getLocalPlayer().getWorldLocation()) > 10) {
            return;
        }
        TileItem despawnedItem = itemDespawned.getItem();
        List<Deathpile> updatedDeathpiles = this.removeFromDeathpiles(despawnedItem, worldPoint);
        if (updatedDeathpiles.isEmpty()) {
            return;
        }
        ListIterator<Deathpile> iterator = updatedDeathpiles.listIterator();
        while (iterator.hasNext()) {
            Deathpile deathpile = iterator.next();
            if (!deathpile.getItems().isEmpty()) continue;
            deathpile.deleteData(this);
            this.storages.remove(deathpile);
            iterator.remove();
        }
        if (updatedDeathpiles.isEmpty()) {
            SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
        } else {
            this.updateStorages((List<? extends DeathStorage>)updatedDeathpiles);
        }
    }

    private List<Deathpile> removeFromDeathpiles(TileItem item, WorldPoint worldPoint) {
        AtomicLong quantityToRemove = new AtomicLong(item.getQuantity());
        if (quantityToRemove.get() == 65535L) {
            quantityToRemove.set(Long.MAX_VALUE);
        }
        return this.getDeathpiles().filter(deathpile -> !deathpile.hasExpired()).filter(deathpile -> deathpile.getWorldPoint().equals((Object)worldPoint)).filter(deathpile -> {
            long itemsRemoved = deathpile.remove(item.getId(), quantityToRemove.get());
            quantityToRemove.addAndGet(-itemsRemoved);
            return itemsRemoved > 0L;
        }).collect(Collectors.toList());
    }

    @Override
    public String getConfigKey() {
        return "death";
    }

    int getPlayedMinutes() {
        if (this.isPreviewManager) {
            return this.startPlayedMinutes;
        }
        return (int)((long)this.startPlayedMinutes + (System.currentTimeMillis() - this.startMs) / 60000L);
    }

    List<ItemStack> getDeathItems() {
        List<ItemStack> itemStacks = this.carryableStorageManager.getStorages().stream().filter(s -> s.getType() == CarryableStorageType.INVENTORY || s.getType() == CarryableStorageType.EQUIPMENT).sorted(Comparator.comparingInt(s -> s.getType() == CarryableStorageType.INVENTORY ? 0 : 1)).flatMap(s -> s.getItems().stream()).collect(Collectors.toList());
        return ItemStackUtils.compound(ItemStackUtils.filterDestroyedOnDeath(ItemStackUtils.explodeStorageItems(itemStacks, this.carryableStorageManager)).stream().filter(i -> i.getId() != -1 && i.getQuantity() > 0L).collect(Collectors.toList()), false);
    }

    @Override
    public void load(String profileKey) {
        if (!this.enabled) {
            return;
        }
        this.loadDeathpiles(profileKey);
        this.loadGraves(profileKey);
        this.loadDeathbanks(profileKey);
        this.deathsOffice.load(this.configManager, this.getConfigKey(), profileKey);
    }

    @Override
    public void reset() {
        this.oldInventoryItems = null;
        this.storages.removeIf(s -> s instanceof ExpiringDeathStorage || s instanceof Deathbank);
        this.deathbank = null;
        this.enable();
        this.refreshMapPoints();
    }

    void refreshMapPoints() {
        if (this.worldMapPointManager == null || this.isPreviewManager) {
            return;
        }
        this.worldMapPointManager.removeIf(DeathWorldMapPoint.class::isInstance);
        AtomicInteger index = new AtomicInteger(1);
        this.storages.stream().filter(Deathpile.class::isInstance).map(Deathpile.class::cast).filter(deathpile -> !deathpile.hasExpired()).forEach(deathpile -> {
            deathpile.worldMapPoint = new DeathWorldMapPoint(deathpile.getWorldPoint(), this.itemManager, index.getAndIncrement());
            this.worldMapPointManager.add((WorldMapPoint)deathpile.getWorldMapPoint());
        });
    }

    private void loadDeathpiles(String profileKey) {
        for (String configurationKey : this.configManager.getRSProfileConfigurationKeys("dudewheresmystuff", profileKey, this.getConfigKey() + "." + DeathStorageType.DEATHPILE.getConfigKey() + ".")) {
            Deathpile deathpile = Deathpile.load(this.plugin, this, profileKey, configurationKey.split("\\.")[2]);
            SwingUtilities.invokeLater(() -> {
                deathpile.createStoragePanel(this);
                if (deathpile.getStoragePanel() != null) {
                    this.plugin.getClientThread().invoke(() -> {
                        deathpile.getStoragePanel().refreshItems();
                        SwingUtilities.invokeLater(() -> deathpile.getStoragePanel().update());
                    });
                }
            });
            this.storages.add(deathpile);
        }
        this.refreshMapPoints();
    }

    private void loadGraves(String profileKey) {
        for (String configurationKey : this.configManager.getRSProfileConfigurationKeys("dudewheresmystuff", profileKey, this.getConfigKey() + "." + DeathStorageType.GRAVE.getConfigKey() + ".")) {
            Grave loadedGrave = Grave.load(this.plugin, this, profileKey, configurationKey.split("\\.")[2]);
            SwingUtilities.invokeLater(() -> {
                loadedGrave.createStoragePanel(this);
                if (loadedGrave.getStoragePanel() != null) {
                    this.plugin.getClientThread().invoke(() -> {
                        loadedGrave.getStoragePanel().refreshItems();
                        SwingUtilities.invokeLater(() -> loadedGrave.getStoragePanel().update());
                    });
                }
            });
            if (!loadedGrave.hasExpired()) {
                if (this.grave != null) {
                    if (this.grave.getExpiryMs() < loadedGrave.getExpiryMs()) {
                        this.grave.expire();
                        this.grave = loadedGrave;
                    } else {
                        loadedGrave.expire();
                    }
                } else {
                    this.grave = loadedGrave;
                }
            }
            this.storages.add(loadedGrave);
        }
        this.refreshMapPoints();
    }

    private void loadDeathbanks(String profileKey) {
        for (String configurationKey : this.configManager.getRSProfileConfigurationKeys("dudewheresmystuff", profileKey, this.getConfigKey() + "." + DeathStorageType.DEATHBANK.getConfigKey() + ".")) {
            Deathbank loadedDeathbank = Deathbank.load(this.plugin, this, profileKey, configurationKey.split("\\.")[2]);
            if (loadedDeathbank == null) continue;
            SwingUtilities.invokeLater(() -> loadedDeathbank.createStoragePanel(this));
            if (loadedDeathbank.isActive()) {
                if (this.deathbank != null) {
                    if (this.deathbank.getLastUpdated() <= loadedDeathbank.getLastUpdated()) {
                        this.deathbank.setLostAt(System.currentTimeMillis());
                        this.deathbank = loadedDeathbank;
                    } else {
                        loadedDeathbank.setLostAt(System.currentTimeMillis());
                    }
                } else {
                    this.deathbank = loadedDeathbank;
                }
            }
            this.storages.add(loadedDeathbank);
        }
    }

    private boolean deathpilesUseAccountPlayTime() {
        return this.plugin.getConfig().deathpilesUseAccountPlayTime() && this.startPlayedMinutes != 0;
    }

    public void deleteExpiringDeathStorages(boolean includeActive) {
        Iterator iterator = this.storages.iterator();
        while (iterator.hasNext()) {
            DeathStorage storage = (DeathStorage)iterator.next();
            if (!(storage instanceof Deathpile) && !(storage instanceof Grave) || !includeActive && !((ExpiringDeathStorage)storage).hasExpired()) continue;
            iterator.remove();
            storage.deleteData(this);
        }
        SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
    }

    public void deleteDeathbanks(boolean includeActive) {
        Iterator iterator = this.storages.iterator();
        while (iterator.hasNext()) {
            DeathStorage storage = (DeathStorage)iterator.next();
            if (!(storage instanceof Deathbank) || !includeActive && ((Deathbank)storage).isActive()) continue;
            iterator.remove();
            storage.deleteData(this);
        }
        SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
    }

    void deleteStorage(ExpiringDeathStorage expiringDeathStorage) {
        this.storages.remove(expiringDeathStorage);
        this.refreshMapPoints();
        SwingUtilities.invokeLater(() -> this.getStorageTabPanel().reorderStoragePanels());
        expiringDeathStorage.deleteData(this);
        if (expiringDeathStorage instanceof Grave && expiringDeathStorage == this.grave) {
            this.grave = null;
        }
    }

    public DeathsOffice getDeathsOffice() {
        return this.deathsOffice;
    }

    @Nullable
    public Deathbank getDeathbank() {
        return this.deathbank;
    }

    @Nullable
    public Grave getGrave() {
        return this.grave;
    }

    public void setCarryableStorageManager(CarryableStorageManager carryableStorageManager) {
        this.carryableStorageManager = carryableStorageManager;
    }

    public void setCoinsStorageManager(CoinsStorageManager coinsStorageManager) {
        this.coinsStorageManager = coinsStorageManager;
    }

    public int getStartPlayedMinutes() {
        return this.startPlayedMinutes;
    }

    public void setStartPlayedMinutes(int startPlayedMinutes) {
        this.startPlayedMinutes = startPlayedMinutes;
    }
}

