/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.death;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StoragePanel;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorage;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageType;
import java.util.Objects;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.config.ConfigManager;

public class DeathItems
extends DeathStorage {
    private final DeathStorageManager deathStorageManager;

    protected DeathItems(DudeWheresMyStuffPlugin plugin, DeathStorageManager deathStorageManager) {
        super(DeathStorageType.DEATH_ITEMS, plugin);
        this.deathStorageManager = deathStorageManager;
    }

    @Override
    protected void createStoragePanel(StorageManager<?, ?> storageManager) {
        this.storagePanel = new StoragePanel(this.plugin, this, false, false);
        this.storagePanel.collapse(true);
        this.createComponentPopupMenu(storageManager);
    }

    @Override
    protected void createComponentPopupMenu(StorageManager<?, ?> storageManager) {
        if (!this.plugin.isDeveloperMode() || this.deathStorageManager.isPreviewManager() || this.storagePanel == null) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.storagePanel.setComponentPopupMenu(popupMenu);
        JMenuItem createDeathpile = new JMenuItem("Create Deathpile");
        createDeathpile.addActionListener(e -> {
            WorldPoint location = Objects.requireNonNull(this.plugin.getClient().getLocalPlayer()).getWorldLocation();
            this.deathStorageManager.createDeathpile(location, this.items);
            this.deathStorageManager.getStorageTabPanel().reorderStoragePanels();
        });
        popupMenu.add(createDeathpile);
        JMenuItem createGrave = new JMenuItem("Create Grave");
        createGrave.addActionListener(e -> {
            WorldPoint location = Objects.requireNonNull(this.plugin.getClient().getLocalPlayer()).getWorldLocation();
            this.deathStorageManager.createGrave(location, this.items);
            this.deathStorageManager.getStorageTabPanel().reorderStoragePanels();
        });
        popupMenu.add(createGrave);
    }

    @Override
    public void softUpdate() {
        this.plugin.getClientThread().invoke(() -> {
            this.items.clear();
            this.items.addAll(this.deathStorageManager.getDeathItems());
            if (this.storagePanel != null) {
                this.storagePanel.refreshItems();
                SwingUtilities.invokeLater(() -> this.storagePanel.update());
            }
        });
    }

    @Override
    public void save(ConfigManager configManager, String profileKey, String managerConfigKey) {
    }

    @Override
    public void load(ConfigManager configManager, String managerConfigKey, String profileKey) {
    }

    @Override
    public boolean isWithdrawable() {
        return false;
    }
}

