/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.coins;

import com.google.inject.Inject;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.BountyHunterCoffer;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorage;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageType;
import dev.thource.runelite.dudewheresmystuff.coins.GrandExchange;
import dev.thource.runelite.dudewheresmystuff.coins.LootingBag;
import dev.thource.runelite.dudewheresmystuff.coins.ServantsMoneybag;
import dev.thource.runelite.dudewheresmystuff.coins.ShiloFurnace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoinsStorageManager
extends StorageManager<CoinsStorageType, CoinsStorage> {
    private static final Logger log = LoggerFactory.getLogger(CoinsStorageManager.class);

    @Inject
    CoinsStorageManager(DudeWheresMyStuffPlugin plugin) {
        super(plugin);
        for (CoinsStorageType type : CoinsStorageType.values()) {
            if (type == CoinsStorageType.SERVANT_MONEYBAG || type == CoinsStorageType.SHILO_FURNACE || type == CoinsStorageType.GRAND_EXCHANGE || type == CoinsStorageType.LOOTING_BAG || type == CoinsStorageType.BOUNTY_HUNTER) continue;
            this.storages.add(new CoinsStorage(type, plugin));
        }
        this.storages.add(new ServantsMoneybag(plugin));
        this.storages.add(new ShiloFurnace(plugin));
        this.storages.add(new GrandExchange(plugin));
        this.storages.add(new LootingBag(plugin));
        this.storages.add(new BountyHunterCoffer(plugin));
    }

    @Override
    public String getConfigKey() {
        return "coins";
    }
}

