/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.coins;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.ItemStorage;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageType;
import java.util.Optional;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;

public class CoinsStorage
extends ItemStorage<CoinsStorageType> {
    protected final ItemStack coinStack = new ItemStack(995, "Coins", 0L, 1, 0, true);

    protected CoinsStorage(CoinsStorageType type, DudeWheresMyStuffPlugin plugin) {
        super(type, plugin);
        this.hasStaticItems = true;
        this.items.add(this.coinStack);
    }

    @Override
    public boolean onGameTick() {
        if (this.itemContainerWatcher != null && this.itemContainerWatcher.wasJustUpdated()) {
            Optional<ItemStack> coinsItem = this.itemContainerWatcher.getItems().stream().filter(i -> i.getId() == 995).findFirst();
            this.coinStack.setQuantity(coinsItem.map(ItemStack::getQuantity).orElse(0L));
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public boolean onVarbitChanged() {
        if (((CoinsStorageType)this.type).getVarbitId() == -1) {
            return false;
        }
        int coins = this.plugin.getClient().getVarbitValue(((CoinsStorageType)this.type).getVarbitId()) * ((CoinsStorageType)this.type).getMultiplier();
        if (this.coinStack.getQuantity() == (long)coins) {
            return false;
        }
        this.coinStack.setQuantity(coins);
        return true;
    }

    @Override
    public boolean onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (this.itemContainerWatcher != null || ((CoinsStorageType)this.type).getItemContainerId() != itemContainerChanged.getContainerId()) {
            return false;
        }
        ItemContainer itemContainer = itemContainerChanged.getItemContainer();
        if (itemContainer == null) {
            return false;
        }
        this.lastUpdated = System.currentTimeMillis();
        int coins = itemContainer.count(995);
        if (this.coinStack.getQuantity() == (long)coins) {
            return !((CoinsStorageType)this.getType()).isAutomatic();
        }
        this.coinStack.setQuantity(coins);
        return true;
    }

    public ItemStack getCoinStack() {
        return this.coinStack;
    }
}

