/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import java.util.Arrays;
import net.runelite.api.EnumComposition;

public class RunePouch
extends CarryableStorage {
    private static final String EMPTY = "empty";
    private static final int[] runeTypeVarbits = new int[]{29, 1622, 1623, 14285};
    private static final int[] runeQuantityVarbits = new int[]{1624, 1625, 1626, 14286};
    private static final int MAX_RUNE_TYPES = runeTypeVarbits.length;
    private int[] runeTypes = new int[MAX_RUNE_TYPES];
    private int[] runeQuantities = new int[MAX_RUNE_TYPES];

    RunePouch(DudeWheresMyStuffPlugin plugin) {
        super(CarryableStorageType.RUNE_POUCH, plugin);
    }

    @Override
    public boolean onVarbitChanged() {
        int i;
        int[] newTypes = new int[MAX_RUNE_TYPES];
        int[] newQuantities = new int[MAX_RUNE_TYPES];
        for (i = 0; i < MAX_RUNE_TYPES; ++i) {
            newTypes[i] = this.plugin.getClient().getVarbitValue(runeTypeVarbits[i]);
        }
        for (i = 0; i < MAX_RUNE_TYPES; ++i) {
            newQuantities[i] = this.plugin.getClient().getVarbitValue(runeQuantityVarbits[i]);
        }
        if (Arrays.equals(newQuantities, this.runeQuantities) && Arrays.equals(newTypes, this.runeTypes)) {
            return false;
        }
        this.runeQuantities = newQuantities;
        this.runeTypes = newTypes;
        this.refreshItems();
        return true;
    }

    private void refreshItems() {
        this.items.clear();
        EnumComposition runepouchEnum = this.plugin.getClient().getEnum(982);
        for (int i = 0; i < MAX_RUNE_TYPES; ++i) {
            int runeId = runepouchEnum.getIntValue(this.runeTypes[i]);
            if (runeId != -1) {
                this.items.add(new ItemStack(runeId, this.runeQuantities[i], this.plugin));
                continue;
            }
            this.items.add(new ItemStack(-1, EMPTY, 1L, 0, 0, false));
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < MAX_RUNE_TYPES; ++i) {
            this.runeTypes[i] = 0;
            this.runeQuantities[i] = 0;
        }
    }

    public int[] getRuneTypes() {
        return this.runeTypes;
    }

    public int[] getRuneQuantities() {
        return this.runeQuantities;
    }
}

