/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.math.NumberUtils;

public class PlankSack
extends CarryableStorage {
    private static final Pattern chatPattern = Pattern.compile("Basic\\u00A0planks:\\u00A0(\\d+), Oak\\u00A0planks:\\u00A0(\\d+), Teak\\u00A0planks:\\u00A0(\\d+), Mahogany\\u00A0planks:\\u00A0(\\d+)");
    private static final Pattern usePattern = Pattern.compile(".*[Pp]lank -> Plank sack");
    private final ItemStack plankStack;
    private final ItemStack oakPlankStack;
    private final ItemStack teakPlankStack;
    private final ItemStack mahoganyPlankStack;

    PlankSack(DudeWheresMyStuffPlugin plugin) {
        super(CarryableStorageType.PLANK_SACK, plugin);
        this.hasStaticItems = true;
        this.plankStack = new ItemStack(960, plugin);
        this.oakPlankStack = new ItemStack(8778, plugin);
        this.teakPlankStack = new ItemStack(8780, plugin);
        this.mahoganyPlankStack = new ItemStack(8782, plugin);
        this.items.add(this.plankStack);
        this.items.add(this.oakPlankStack);
        this.items.add(this.teakPlankStack);
        this.items.add(this.mahoganyPlankStack);
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        if (chatMessage.getMessage().equals("Your sack is empty.")) {
            this.plankStack.setQuantity(0L);
            this.oakPlankStack.setQuantity(0L);
            this.teakPlankStack.setQuantity(0L);
            this.mahoganyPlankStack.setQuantity(0L);
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        Matcher matcher = chatPattern.matcher(Text.removeTags((String)chatMessage.getMessage()));
        if (!matcher.matches()) {
            return false;
        }
        this.plankStack.setQuantity(NumberUtils.toInt((String)matcher.group(1)));
        this.oakPlankStack.setQuantity(NumberUtils.toInt((String)matcher.group(2)));
        this.teakPlankStack.setQuantity(NumberUtils.toInt((String)matcher.group(3)));
        this.mahoganyPlankStack.setQuantity(NumberUtils.toInt((String)matcher.group(4)));
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    public ItemStack getPlankStack() {
        return this.plankStack;
    }

    public ItemStack getOakPlankStack() {
        return this.oakPlankStack;
    }

    public ItemStack getTeakPlankStack() {
        return this.teakPlankStack;
    }

    public ItemStack getMahoganyPlankStack() {
        return this.mahoganyPlankStack;
    }
}

