/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnomishFirelighter
extends CarryableStorage {
    private static final Logger log = LoggerFactory.getLogger(GnomishFirelighter.class);
    private static final Pattern chargesPattern = Pattern.compile("(\\d+) (\\w+) firelighter charges");

    GnomishFirelighter(DudeWheresMyStuffPlugin plugin) {
        super(CarryableStorageType.GNOMISH_FIRELIGHTER, plugin);
        this.hasStaticItems = true;
        this.items.add(new ItemStack(7329, 0L, plugin));
        this.items.add(new ItemStack(7330, 0L, plugin));
        this.items.add(new ItemStack(7331, 0L, plugin));
        this.items.add(new ItemStack(10326, 0L, plugin));
        this.items.add(new ItemStack(10327, 0L, plugin));
    }

    @Override
    public boolean onGameTick() {
        Widget widget = this.plugin.getClient().getWidget(193, 2);
        if (widget == null) {
            return false;
        }
        String widgetText = widget.getText().replace("<br>", " ");
        if (!widgetText.contains("gnomish firelighter")) {
            return false;
        }
        if (widgetText.contains("is empty")) {
            this.items.forEach(itemStack -> itemStack.setQuantity(0L));
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        Matcher matcher = chargesPattern.matcher(widgetText);
        int charges = 0;
        Optional<Object> itemStack2 = Optional.empty();
        if (matcher.find()) {
            charges = NumberUtils.toInt((String)matcher.group(1));
            itemStack2 = this.items.stream().filter(i -> i.getName().contains(matcher.group(2))).findFirst();
        }
        if (!itemStack2.isPresent()) {
            return false;
        }
        ((ItemStack)itemStack2.get()).setQuantity(charges);
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        if (!chatMessage.getMessage().startsWith("You uncharge the gnomish firelighter")) {
            return false;
        }
        this.items.forEach(itemStack -> itemStack.setQuantity(0L));
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }
}

