/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import com.google.inject.Inject;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.BoltPouch;
import dev.thource.runelite.dudewheresmystuff.carryable.BottomlessBucket;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import dev.thource.runelite.dudewheresmystuff.carryable.GnomishFirelighter;
import dev.thource.runelite.dudewheresmystuff.carryable.LootingBag;
import dev.thource.runelite.dudewheresmystuff.carryable.MasterScrollBook;
import dev.thource.runelite.dudewheresmystuff.carryable.PlankSack;
import dev.thource.runelite.dudewheresmystuff.carryable.RunePouch;
import dev.thource.runelite.dudewheresmystuff.carryable.SeedBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CarryableStorageManager
extends StorageManager<CarryableStorageType, CarryableStorage> {
    private static final Logger log = LoggerFactory.getLogger(CarryableStorageManager.class);
    private final BottomlessBucket bottomlessBucket;

    @Inject
    private CarryableStorageManager(DudeWheresMyStuffPlugin plugin) {
        super(plugin);
        this.bottomlessBucket = new BottomlessBucket(plugin);
        this.storages.add(new CarryableStorage(CarryableStorageType.EQUIPMENT, plugin));
        this.storages.add(new CarryableStorage(CarryableStorageType.INVENTORY, plugin));
        this.storages.add(new LootingBag(plugin));
        this.storages.add(new SeedBox(plugin));
        this.storages.add(new RunePouch(plugin));
        this.storages.add(this.bottomlessBucket);
        this.storages.add(new PlankSack(plugin));
        this.storages.add(new BoltPouch(plugin));
        this.storages.add(new GnomishFirelighter(plugin));
        this.storages.add(new MasterScrollBook(plugin));
    }

    @Override
    public String getConfigKey() {
        return "carryable";
    }

    public BottomlessBucket getBottomlessBucket() {
        return this.bottomlessBucket;
    }
}

