/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.ChatMessageType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.widgets.Widget;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BottomlessBucket
extends CarryableStorage {
    private static final Logger log = LoggerFactory.getLogger(BottomlessBucket.class);
    private static final Pattern chargesPattern = Pattern.compile("(\\d+) uses");
    private final ItemStack compostStack;
    private final ItemStack supercompostStack;
    private final ItemStack ultracompostStack;

    BottomlessBucket(DudeWheresMyStuffPlugin plugin) {
        super(CarryableStorageType.BOTTOMLESS_BUCKET, plugin);
        this.hasStaticItems = true;
        this.compostStack = new ItemStack(6032, plugin);
        this.supercompostStack = new ItemStack(6034, plugin);
        this.ultracompostStack = new ItemStack(21483, plugin);
        this.items.add(this.compostStack);
        this.items.add(this.supercompostStack);
        this.items.add(this.ultracompostStack);
        plugin.getClientThread().invokeLater(() -> this.items.forEach(ItemStack::stripPrices));
    }

    @Override
    public boolean onGameTick() {
        Widget widget = this.plugin.getClient().getWidget(193, 2);
        if (widget == null) {
            return false;
        }
        String widgetText = widget.getText().replace("<br>", " ").replace(",", "");
        if (!widgetText.contains("compost bucket")) {
            return false;
        }
        if (widgetText.contains("currently empty") || widgetText.startsWith("You discard")) {
            this.compostStack.setQuantity(0L);
            this.supercompostStack.setQuantity(0L);
            this.ultracompostStack.setQuantity(0L);
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        Matcher matcher = chargesPattern.matcher(widgetText);
        int charges = 1;
        if (matcher.find()) {
            charges = NumberUtils.toInt((String)matcher.group(1));
        } else if (!widgetText.contains("one use")) {
            return false;
        }
        this.compostStack.setQuantity(0L);
        this.supercompostStack.setQuantity(0L);
        this.ultracompostStack.setQuantity(0L);
        this.lastUpdated = System.currentTimeMillis();
        if (widgetText.contains("ultracompost")) {
            this.ultracompostStack.setQuantity(charges);
        } else if (widgetText.contains("supercompost")) {
            this.supercompostStack.setQuantity(charges);
        } else {
            this.compostStack.setQuantity(charges);
        }
        return true;
    }

    public void updateCompost(int type, int charges) {
        if (type == 0) {
            return;
        }
        this.compostStack.setQuantity(0L);
        this.supercompostStack.setQuantity(0L);
        this.ultracompostStack.setQuantity(0L);
        this.lastUpdated = System.currentTimeMillis();
        if (type == 2) {
            this.compostStack.setQuantity(charges);
        } else if (type == 3) {
            this.supercompostStack.setQuantity(charges);
        } else if (type == 4) {
            this.ultracompostStack.setQuantity(charges);
        }
    }

    @Override
    public boolean onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() != ChatMessageType.SPAM && chatMessage.getType() != ChatMessageType.GAMEMESSAGE) {
            return false;
        }
        if (!chatMessage.getMessage().startsWith("Your bottomless compost bucket has")) {
            return false;
        }
        if (chatMessage.getMessage().contains("run out")) {
            this.compostStack.setQuantity(0L);
            this.supercompostStack.setQuantity(0L);
            this.ultracompostStack.setQuantity(0L);
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        Matcher matcher = chargesPattern.matcher(chatMessage.getMessage().replace(",", ""));
        int charges = 1;
        if (matcher.find()) {
            charges = NumberUtils.toInt((String)matcher.group(1));
        } else if (!chatMessage.getMessage().contains("single use")) {
            return false;
        }
        this.compostStack.setQuantity(0L);
        this.supercompostStack.setQuantity(0L);
        this.ultracompostStack.setQuantity(0L);
        this.lastUpdated = System.currentTimeMillis();
        if (chatMessage.getMessage().contains("ultracompost")) {
            this.ultracompostStack.setQuantity(charges);
        } else if (chatMessage.getMessage().contains("supercompost")) {
            this.supercompostStack.setQuantity(charges);
        } else {
            this.compostStack.setQuantity(charges);
        }
        return true;
    }

    @Override
    public boolean isWithdrawable() {
        return false;
    }
}

