/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff.carryable;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltPouch
extends CarryableStorage {
    private static final Logger log = LoggerFactory.getLogger(BoltPouch.class);
    private static final int[] BOLT_TYPE_VARBITS = new int[]{2473, 2474, 2475, 2476};
    private static final int[] BOLT_COUNT_VARBITS = new int[]{2469, 2470, 2471, 2472};
    private static final int[] BOLT_ITEM_IDS = new int[]{-1, 877, 9139, 9140, 9141, 9142, 9143, 9144, 9145, 878, 9286, 9287, 9288, 9289, 9290, 9291, 9292, 6061, 9293, 9294, 9295, 9296, 9297, 9298, 9299, 6062, 9300, 9301, 9302, 9303, 9304, 9305, 9306, 879, 9335, 880, 9336, 9337, 9338, 9339, 9340, 9341, 9342, 9236, 9237, 9238, 9239, 9240, 9241, 9242, 9243, 9244, 9245, 9419, 881, 8882, 11875, 21316, 21905, 21924, 21926, 21928, 21955, 21957, 21959, 21961, 21963, 21965, 21967, 21969, 21971, 21973, 21932, 21934, 21936, 21938, 21940, 21942, 21944, 21946, 21948, 21950, 4740};

    BoltPouch(DudeWheresMyStuffPlugin plugin) {
        super(CarryableStorageType.BOLT_POUCH, plugin);
        this.items.add(new ItemStack(-1, 0L, plugin));
        this.items.add(new ItemStack(-1, 0L, plugin));
        this.items.add(new ItemStack(-1, 0L, plugin));
        this.items.add(new ItemStack(-1, 0L, plugin));
    }

    @Override
    public boolean onVarbitChanged() {
        boolean updated = false;
        for (int i = 0; i < BOLT_TYPE_VARBITS.length; ++i) {
            int boltCount = this.plugin.getClient().getVarbitValue(BOLT_COUNT_VARBITS[i]);
            int boltItemId = this.getBoltItemId(this.plugin.getClient().getVarbitValue(BOLT_TYPE_VARBITS[i]));
            ItemStack boltStack = (ItemStack)this.items.get(i);
            if ((long)boltCount != boltStack.getQuantity()) {
                boltStack.setQuantity(boltCount);
                updated = true;
            }
            if (boltItemId == boltStack.getId()) continue;
            boltStack.setId(boltItemId, this.plugin);
            updated = true;
        }
        return updated;
    }

    private int getBoltItemId(int varbitValue) {
        if (varbitValue < 0 || varbitValue >= BOLT_ITEM_IDS.length) {
            return -1;
        }
        return BOLT_ITEM_IDS[varbitValue];
    }

    @Override
    public void load(ConfigManager configManager, String managerConfigKey, String profileKey) {
        super.load(configManager, managerConfigKey, profileKey);
        while (this.items.size() < 4) {
            this.items.add(new ItemStack(-1, 0L, this.plugin));
        }
    }

    @Override
    public void reset() {
        this.lastUpdated = -1L;
        this.lastSaveString = null;
        this.enable();
    }
}

