/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.common.collect.ImmutableMap;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageManager;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageManager;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageManager;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Tab {
    OVERVIEW("Overview", 20770),
    COINS("Coins", 995, 12246183),
    CARRYABLE_STORAGE("Carry-able Storage", 11941),
    WORLD("World Storage", 21307),
    MINIGAMES("Minigames", 6885),
    DEATH("Death Storage", 964),
    POH_STORAGE("POH Storage", 9828),
    STASH_UNITS("STASH Units", 25611),
    SEARCH("Search", -1);

    public static final ImmutableMap<Class<? extends StorageManager<?, ?>>, Tab> MANAGER_TAB_MAP;
    public static final List<Tab> TABS;
    private final String name;
    private final int itemId;
    private final int itemQuantity;

    private Tab(String name, int itemId) {
        this.name = name;
        this.itemId = itemId;
        this.itemQuantity = 1;
    }

    private Tab(String name, int itemId, int itemQuantity) {
        this.name = name;
        this.itemId = itemId;
        this.itemQuantity = itemQuantity;
    }

    public String getName() {
        return this.name;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getItemQuantity() {
        return this.itemQuantity;
    }

    static {
        MANAGER_TAB_MAP = ImmutableMap.builder().put(DeathStorageManager.class, (Object)DEATH).put(CoinsStorageManager.class, (Object)COINS).put(CarryableStorageManager.class, (Object)CARRYABLE_STORAGE).put(WorldStorageManager.class, (Object)WORLD).put(StashStorageManager.class, (Object)STASH_UNITS).put(PlayerOwnedHouseStorageManager.class, (Object)POH_STORAGE).put(MinigamesStorageManager.class, (Object)MINIGAMES).build();
        TABS = Collections.unmodifiableList(Arrays.asList(OVERVIEW, DEATH, COINS, CARRYABLE_STORAGE, STASH_UNITS, POH_STORAGE, WORLD, MINIGAMES, SEARCH));
    }
}

