/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.EnhancedSwingUtilities;
import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StoragePanel;
import dev.thource.runelite.dudewheresmystuff.StorageType;
import dev.thource.runelite.dudewheresmystuff.TabContentPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public abstract class StorageTabPanel<T extends StorageType, S extends Storage<T>, M extends StorageManager<T, S>>
extends TabContentPanel {
    protected final transient DudeWheresMyStuffPlugin plugin;
    protected final transient M storageManager;
    protected final JPanel storagePanelContainer;
    protected final JComboBox<ItemSortMode> sortItemsDropdown;
    protected final transient List<StoragePanel> storagePanels = new ArrayList<StoragePanel>();

    protected StorageTabPanel(DudeWheresMyStuffPlugin plugin, M storageManager) {
        this.plugin = plugin;
        this.storageManager = storageManager;
        ((StorageManager)storageManager).setStorageTabPanel(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel sortItemsContainer = new JPanel();
        sortItemsContainer.setLayout(new BoxLayout(sortItemsContainer, 0));
        this.add(sortItemsContainer);
        JLabel sortItemsLabel = new JLabel();
        sortItemsLabel.setFont(FontManager.getRunescapeFont());
        sortItemsLabel.setForeground(Color.WHITE);
        sortItemsLabel.setText("Sort items by");
        sortItemsLabel.setBorder(new EmptyBorder(0, 0, 0, 8));
        sortItemsContainer.add(sortItemsLabel);
        this.sortItemsDropdown = new JComboBox();
        this.sortItemsDropdown.setFont(FontManager.getRunescapeFont());
        this.sortItemsDropdown.setForeground(Color.WHITE);
        this.sortItemsDropdown.addItem(ItemSortMode.VALUE);
        this.sortItemsDropdown.addItem(ItemSortMode.UNSORTED);
        this.sortItemsDropdown.setSelectedItem((Object)plugin.getConfig().itemSortMode());
        this.sortItemsDropdown.addItemListener(i -> plugin.getConfig().setItemSortMode((ItemSortMode)((Object)((Object)i.getItem()))));
        this.sortItemsDropdown.setPreferredSize(new Dimension(-1, 30));
        sortItemsContainer.add(this.sortItemsDropdown);
        this.storagePanelContainer = new JPanel();
        this.storagePanelContainer.setLayout(new BoxLayout(this.storagePanelContainer, 1));
        this.add(this.storagePanelContainer);
    }

    protected Comparator<S> getStorageSorter() {
        return Comparator.comparingLong(Storage::getTotalValue).reversed().thenComparingInt(s -> -s.getItems().size()).thenComparing(s -> s.getType().getName());
    }

    public void reorderStoragePanels() {
        EnhancedSwingUtilities.fastRemoveAll(this.storagePanelContainer);
        this.storagePanels.clear();
        ((StorageManager)this.storageManager).getStorages().stream().filter(storage -> storage.getStoragePanel() != null).filter(storage -> this.plugin.getConfig().showEmptyStorages() || !storage.getStoragePanel().getItemBoxes().isEmpty()).sorted(this.getStorageSorter()).forEach(storage -> {
            this.storagePanelContainer.add(storage.getStoragePanel());
            this.storagePanels.add(storage.getStoragePanel());
        });
        this.storagePanelContainer.revalidate();
    }

    @Override
    public void softUpdate() {
        this.storagePanels.forEach(panel -> panel.getStorage().softUpdate());
    }

    public M getStorageManager() {
        return this.storageManager;
    }

    public JComboBox<ItemSortMode> getSortItemsDropdown() {
        return this.sortItemsDropdown;
    }
}

