/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.EnhancedSwingUtilities;
import dev.thource.runelite.dudewheresmystuff.ItemBox;
import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.ItemStackUtils;
import dev.thource.runelite.dudewheresmystuff.Storage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.client.util.Text;

public class StoragePanel
extends JPanel {
    private static final int ITEMS_PER_ROW = 4;
    private static final int TITLE_PADDING = 5;
    private final JPanel titlePanel = new JPanel();
    private final JLabel titleLabel = new JLabel();
    private final JLabel subTitleLabel = new JLabel();
    private final JLabel priceLabel;
    private final JPanel itemContainer = new JPanel();
    private final JPanel footerPanel = new JPanel();
    private final JLabel footerLabel = new JLabel();
    private final transient DudeWheresMyStuffPlugin plugin;
    private final transient Storage<?> storage;
    private final boolean displayEmptyStacks;
    private List<ItemBox> itemBoxes = new ArrayList<ItemBox>();
    @Nullable
    private JComponent popupButton;
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    public StoragePanel(DudeWheresMyStuffPlugin plugin, Storage<?> storage, boolean showPrice, boolean displayEmptyStacks) {
        this.plugin = plugin;
        this.storage = storage;
        this.displayEmptyStacks = displayEmptyStacks;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.setBackground(null);
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 0));
        this.titlePanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.titlePanel.setBackground(ColorScheme.DARKER_GRAY_COLOR.darker());
        this.titlePanel.setInheritsPopupMenu(true);
        this.titleLabel.setText(Text.removeTags((String)storage.getName()));
        this.titleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setMinimumSize(new Dimension(1, this.titleLabel.getPreferredSize().height));
        this.titleLabel.setInheritsPopupMenu(true);
        this.subTitleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.subTitleLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.subTitleLabel.setInheritsPopupMenu(true);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.titlePanel.add(this.subTitleLabel);
        this.titlePanel.add(Box.createHorizontalGlue());
        this.titlePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.titlePanel.addMouseListener(new MouseAdapter(){
            private final Component rigidArea = Box.createRigidArea(new Dimension(5, 0));

            @Override
            public void mouseEntered(MouseEvent e) {
                if (StoragePanel.this.popupButton == null) {
                    return;
                }
                StoragePanel.this.titlePanel.add(this.rigidArea);
                StoragePanel.this.titlePanel.add(StoragePanel.this.popupButton);
                StoragePanel.this.titlePanel.revalidate();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (StoragePanel.this.popupButton == null || !StoragePanel.this.isShowing() || StoragePanel.this.titlePanel.getVisibleRect().contains(e.getPoint())) {
                    return;
                }
                StoragePanel.this.titlePanel.remove(this.rigidArea);
                StoragePanel.this.titlePanel.remove(StoragePanel.this.popupButton);
                StoragePanel.this.titlePanel.revalidate();
            }
        });
        MouseAdapter toggleListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    StoragePanel.this.toggle();
                }
            }
        };
        this.titlePanel.addMouseListener(toggleListener);
        this.subTitleLabel.addMouseListener(toggleListener);
        if (showPrice) {
            this.priceLabel = new JLabel();
            this.priceLabel.setFont(FontManager.getRunescapeSmallFont());
            this.priceLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
            this.titlePanel.add(this.priceLabel);
            this.priceLabel.addMouseListener(toggleListener);
        } else {
            this.priceLabel = null;
        }
        this.itemContainer.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.footerPanel.setLayout(new BoxLayout(this.footerPanel, 0));
        this.footerPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.footerPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.footerPanel.setVisible(false);
        this.footerLabel.setFont(FontManager.getRunescapeSmallFont());
        this.footerLabel.setForeground(Color.WHITE);
        this.footerLabel.setText("Placeholder");
        this.footerLabel.setMinimumSize(new Dimension(1, this.footerLabel.getPreferredSize().height));
        this.footerLabel.setText("");
        this.footerPanel.add(this.footerLabel);
        this.add((Component)this.titlePanel, "North");
        this.add((Component)this.itemContainer, "Center");
        this.add((Component)this.footerPanel, "South");
        this.update();
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        if (popup == null) {
            if (this.popupButton != null) {
                this.titlePanel.remove(this.popupButton);
                this.popupButton = null;
            }
            return;
        }
        if (this.popupButton != null) {
            return;
        }
        this.popupButton = new JButton("\u2026");
        this.popupButton.setPreferredSize(new Dimension(20, -1));
        this.popupButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                StoragePanel.this.getComponentPopupMenu().show(StoragePanel.this.popupButton, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setTitle(String text) {
        this.titleLabel.setText(text);
    }

    public String getSubTitle() {
        return this.subTitleLabel.getText();
    }

    public void setSubTitle(String text) {
        this.subTitleLabel.setText(text);
        this.subTitleLabel.setToolTipText(text);
    }

    public String getFooterText() {
        return this.footerLabel.getText();
    }

    public void setFooterText(String text) {
        this.footerPanel.setVisible(!Objects.equals(text, ""));
        this.footerLabel.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePrice() {
        if (this.priceLabel != null) {
            long totalPrice = 0L;
            List<ItemStack> list = this.items;
            synchronized (list) {
                for (ItemStack item : this.items) {
                    totalPrice += item.getTotalGePrice();
                }
            }
            this.priceLabel.setText(QuantityFormatter.quantityToStackSize((long)totalPrice) + " gp");
            this.priceLabel.setToolTipText(QuantityFormatter.formatNumber((long)totalPrice) + " gp");
        }
    }

    private void redrawItems() {
        EnhancedSwingUtilities.fastRemoveAll(this.itemContainer);
        this.itemContainer.setLayout(null);
        if (this.itemBoxes.stream().anyMatch(itemBox -> itemBox.getItemId() != -1)) {
            int rowSize = (this.itemBoxes.size() % 4 == 0 ? 0 : 1) + this.itemBoxes.size() / 4;
            this.itemContainer.setLayout(new GridLayout(rowSize, 4, 1, 1));
            for (int i = 0; i < rowSize * 4; ++i) {
                if (i < this.itemBoxes.size()) {
                    this.itemContainer.add(this.itemBoxes.get(i));
                    continue;
                }
                this.itemContainer.add(new ItemBox(this.plugin, null, this.displayEmptyStacks));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItems() {
        if (this.storage.getType().isAutomatic() || this.storage.getLastUpdated() != -1L) {
            List<ItemStack> list = this.items;
            synchronized (list) {
                this.itemBoxes = this.items.stream().filter(item -> this.displayEmptyStacks || item.getQuantity() > 0L).map(itemStack -> {
                    ListIterator<ItemBox> itemBoxesIterator = this.itemBoxes.listIterator();
                    while (itemBoxesIterator.hasNext()) {
                        ItemBox box = itemBoxesIterator.next();
                        if (box.getItemId() != itemStack.getId() || box.getItemQuantity() != itemStack.getQuantity()) continue;
                        itemBoxesIterator.remove();
                        return box;
                    }
                    return new ItemBox(this.plugin, (ItemStack)itemStack, this.displayEmptyStacks);
                }).collect(Collectors.toList());
            }
        } else {
            this.itemBoxes.clear();
        }
        this.redrawItems();
    }

    protected List<ItemStack> getNewItems() {
        ItemSortMode itemSortMode = this.plugin.getConfig().itemSortMode();
        Stream<ItemStack> newItemStream = this.storage.getItems().stream().map(ItemStack::new);
        if (itemSortMode == ItemSortMode.VALUE) {
            newItemStream = newItemStream.sorted(Comparator.comparingLong(ItemStack::getTotalGePrice).thenComparing(ItemStack::getTotalHaPrice).reversed());
        }
        List<ItemStack> newItems = newItemStream.collect(Collectors.toList());
        if (itemSortMode != ItemSortMode.UNSORTED) {
            newItems = ItemStackUtils.compound(newItems, true);
        }
        return newItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshItems() {
        List<ItemStack> list = this.items;
        synchronized (list) {
            this.items.clear();
            this.items.addAll(this.getNewItems());
        }
    }

    public void update() {
        this.updatePrice();
        this.updateItems();
        this.revalidate();
    }

    public void toggle() {
        if (this.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    public void collapse() {
        this.collapse(false);
    }

    public void collapse(boolean force) {
        if (!force && this.itemBoxes.isEmpty()) {
            return;
        }
        if (!this.isCollapsed()) {
            this.itemContainer.setVisible(false);
            this.applyDimmer(false, this.titlePanel);
        }
    }

    public void expand() {
        if (this.itemBoxes.isEmpty()) {
            return;
        }
        if (this.isCollapsed()) {
            this.itemContainer.setVisible(true);
            this.applyDimmer(true, this.titlePanel);
        }
    }

    public boolean isCollapsed() {
        return !this.itemContainer.isVisible();
    }

    private void applyDimmer(boolean brighten, JPanel panel) {
        for (Component component : panel.getComponents()) {
            Color color = component.getForeground();
            component.setForeground(brighten ? color.brighter() : color.darker());
        }
    }

    public String getTitleToolTip() {
        return this.titleLabel.getToolTipText();
    }

    public void setTitleToolTip(String text) {
        this.titleLabel.setToolTipText(text);
    }

    public JLabel getFooterLabel() {
        return this.footerLabel;
    }

    public Storage<?> getStorage() {
        return this.storage;
    }

    public List<ItemBox> getItemBoxes() {
        return this.itemBoxes;
    }
}

