/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DataExporter;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageType;
import dev.thource.runelite.dudewheresmystuff.death.DeathItems;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.Deathbank;
import dev.thource.runelite.dudewheresmystuff.death.Deathpile;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageManager;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageManager;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageManager;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageManager;
import java.awt.TrayIcon;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManagerManager {
    private static final Logger log = LoggerFactory.getLogger(StorageManagerManager.class);
    private final CarryableStorageManager carryableStorageManager;
    private final CoinsStorageManager coinsStorageManager;
    private final DeathStorageManager deathStorageManager;
    private final MinigamesStorageManager minigamesStorageManager;
    private final StashStorageManager stashStorageManager;
    private final PlayerOwnedHouseStorageManager playerOwnedHouseStorageManager;
    private final WorldStorageManager worldStorageManager;
    private final List<StorageManager<?, ?>> storageManagers;
    private final DudeWheresMyStuffPlugin plugin;
    private final ConfigManager configManager;
    private String displayName;

    StorageManagerManager(DudeWheresMyStuffPlugin plugin, CarryableStorageManager carryableStorageManager, CoinsStorageManager coinsStorageManager, DeathStorageManager deathStorageManager, MinigamesStorageManager minigamesStorageManager, StashStorageManager stashStorageManager, PlayerOwnedHouseStorageManager playerOwnedHouseStorageManager, WorldStorageManager worldStorageManager) {
        this.plugin = plugin;
        this.configManager = carryableStorageManager.getConfigManager();
        this.carryableStorageManager = carryableStorageManager;
        this.coinsStorageManager = coinsStorageManager;
        this.deathStorageManager = deathStorageManager;
        this.minigamesStorageManager = minigamesStorageManager;
        this.stashStorageManager = stashStorageManager;
        this.playerOwnedHouseStorageManager = playerOwnedHouseStorageManager;
        this.worldStorageManager = worldStorageManager;
        this.displayName = "";
        this.storageManagers = Arrays.asList(carryableStorageManager, coinsStorageManager, deathStorageManager, minigamesStorageManager, stashStorageManager, playerOwnedHouseStorageManager, worldStorageManager);
    }

    void reset() {
        this.storageManagers.forEach(StorageManager::reset);
    }

    public void onActorDeath(ActorDeath actorDeath) {
        this.storageManagers.forEach(storageManager -> storageManager.onActorDeath(actorDeath));
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.storageManagers.forEach(storageManager -> storageManager.onGameStateChanged(gameStateChanged));
    }

    public void load(String profileKey) {
        for (StorageManager<?, ?> storageManager : this.storageManagers) {
            storageManager.load(profileKey);
            SwingUtilities.invokeLater(() -> this.plugin.getClientThread().invoke(() -> {
                storageManager.getStorages().forEach(storage -> {
                    if (storage.getStoragePanel() != null) {
                        storage.getStoragePanel().refreshItems();
                    }
                });
                SwingUtilities.invokeLater(() -> {
                    storageManager.getStorages().forEach(storage -> {
                        if (storage.getStoragePanel() != null) {
                            storage.getStoragePanel().update();
                        }
                    });
                    storageManager.getStorageTabPanel().reorderStoragePanels();
                });
            }));
        }
    }

    public void save(String profileKey) {
        for (StorageManager<?, ?> storageManager : this.storageManagers) {
            storageManager.save(profileKey);
        }
    }

    public void onGameTick() {
        this.storageManagers.forEach(StorageManager::onGameTick);
    }

    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        this.storageManagers.forEach(manager -> manager.onWidgetLoaded(widgetLoaded));
    }

    public void onWidgetClosed(WidgetClosed widgetClosed) {
        this.storageManagers.forEach(manager -> manager.onWidgetClosed(widgetClosed));
    }

    public void onVarbitChanged() {
        this.storageManagers.forEach(StorageManager::onVarbitChanged);
    }

    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        this.storageManagers.forEach(manager -> manager.onItemContainerChanged(itemContainerChanged));
    }

    public void onItemDespawned(ItemDespawned itemDespawned) {
        this.storageManagers.forEach(manager -> manager.onItemDespawned(itemDespawned));
    }

    public void onChatMessage(ChatMessage chatMessage) {
        this.storageManagers.forEach(manager -> manager.onChatMessage(chatMessage));
    }

    public Stream<? extends Storage<? extends Enum<? extends Enum<?>>>> getStorages() {
        return Stream.of(this.getDeathStorageManager().getStorages().stream().filter(s -> !(s instanceof DeathItems)).filter(s -> s instanceof Deathpile && !((Deathpile)s).hasExpired() || s instanceof Deathbank && ((Deathbank)s).isActive()), this.getCoinsStorageManager().getStorages().stream().filter(storage -> storage.getType() != CoinsStorageType.INVENTORY && storage.getType() != CoinsStorageType.LOOTING_BAG), this.getCarryableStorageManager().getStorages().stream(), this.getStashStorageManager().getStorages().stream(), this.getPlayerOwnedHouseStorageManager().getStorages().stream(), this.getWorldStorageManager().getStorages().stream()).flatMap(i -> i);
    }

    public List<ItemStack> getItems() {
        return this.getStorages().filter(Storage::isEnabled).map(Storage::getItems).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void onMenuOptionClicked(MenuOptionClicked menuOption) {
        this.storageManagers.forEach(manager -> manager.onMenuOptionClicked(menuOption));
    }

    public void exportItems() {
        DataExporter exporter = new DataExporter(this.displayName, this);
        exporter.setMergeItems(this.plugin.getConfig().csvCombineItems());
        try {
            String filePath = exporter.export();
            this.plugin.getNotifier().notify("Items successfully exported to: " + filePath, TrayIcon.MessageType.INFO);
        }
        catch (IOException | IllegalArgumentException e) {
            log.error("Unable to export: " + e.getMessage());
            this.plugin.getNotifier().notify("Item export failed.", TrayIcon.MessageType.ERROR);
        }
    }

    public CarryableStorageManager getCarryableStorageManager() {
        return this.carryableStorageManager;
    }

    public CoinsStorageManager getCoinsStorageManager() {
        return this.coinsStorageManager;
    }

    public DeathStorageManager getDeathStorageManager() {
        return this.deathStorageManager;
    }

    public MinigamesStorageManager getMinigamesStorageManager() {
        return this.minigamesStorageManager;
    }

    public StashStorageManager getStashStorageManager() {
        return this.stashStorageManager;
    }

    public PlayerOwnedHouseStorageManager getPlayerOwnedHouseStorageManager() {
        return this.playerOwnedHouseStorageManager;
    }

    public WorldStorageManager getWorldStorageManager() {
        return this.worldStorageManager;
    }

    public DudeWheresMyStuffPlugin getPlugin() {
        return this.plugin;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<StorageManager<?, ?>> getStorageManagers() {
        return this.storageManagers;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }
}

