/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.inject.Inject;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.StorageType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.itemidentification.ItemIdentificationConfig;
import net.runelite.client.plugins.itemidentification.ItemIdentificationPlugin;

public abstract class StorageManager<T extends StorageType, S extends Storage<T>> {
    protected final List<S> storages = new ArrayList<S>();
    protected final DudeWheresMyStuffPlugin plugin;
    @Inject
    protected Client client;
    @Inject
    protected ItemManager itemManager;
    @Inject
    protected ConfigManager configManager;
    @Inject
    protected PluginManager pluginManager;
    @Inject
    protected ItemIdentificationPlugin itemIdentificationPlugin;
    @Inject
    protected ItemIdentificationConfig itemIdentificationConfig;
    @Inject
    protected ClientThread clientThread;
    protected boolean enabled = true;
    protected boolean isPreviewManager = false;
    protected StorageTabPanel<T, S, ? extends StorageManager<?, ?>> storageTabPanel;

    protected StorageManager(DudeWheresMyStuffPlugin plugin) {
        this.plugin = plugin;
    }

    public long getTotalValue() {
        return this.storages.stream().filter(Storage::isWithdrawable).mapToLong(Storage::getTotalValue).sum();
    }

    protected void updateStorages(List<? extends S> storages) {
        if (!storages.isEmpty()) {
            storages.forEach(storage -> {
                if (storage.getStoragePanel() != null) {
                    storage.getStoragePanel().refreshItems();
                    SwingUtilities.invokeLater(storage.getStoragePanel()::update);
                }
            });
            SwingUtilities.invokeLater(this.storageTabPanel::reorderStoragePanels);
        }
    }

    public void onGameTick() {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onGameTick()).collect(Collectors.toList()));
        }
    }

    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onWidgetLoaded(widgetLoaded)).collect(Collectors.toList()));
        }
    }

    public void onWidgetClosed(WidgetClosed widgetClosed) {
        if (this.enabled) {
            this.storages.stream().filter(Storage::isEnabled).forEach(storage -> storage.onWidgetClosed(widgetClosed));
        }
    }

    public void onVarbitChanged() {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onVarbitChanged()).collect(Collectors.toList()));
        }
    }

    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onItemContainerChanged(itemContainerChanged)).collect(Collectors.toList()));
        }
    }

    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    public void onActorDeath(ActorDeath actorDeath) {
    }

    public void reset() {
        this.storages.forEach(Storage::reset);
        this.enable();
    }

    public abstract String getConfigKey();

    public void save(String profileKey) {
        if (!this.enabled) {
            return;
        }
        this.storages.forEach(storage -> storage.save(this.configManager, profileKey, this.getConfigKey()));
    }

    public void load(String profileKey) {
        if (!this.enabled || profileKey == null) {
            return;
        }
        this.storages.forEach(storage -> storage.load(this.configManager, this.getConfigKey(), profileKey));
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    public void onItemDespawned(ItemDespawned itemDespawned) {
    }

    public void onChatMessage(ChatMessage chatMessage) {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onChatMessage(chatMessage)).collect(Collectors.toList()));
        }
    }

    public void onMenuOptionClicked(MenuOptionClicked menuOption) {
        if (this.enabled) {
            this.updateStorages(this.storages.stream().filter(storage -> storage.isEnabled() && storage.onMenuOptionClicked(menuOption)).collect(Collectors.toList()));
        }
    }

    public List<S> getStorages() {
        return this.storages;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ItemIdentificationPlugin getItemIdentificationPlugin() {
        return this.itemIdentificationPlugin;
    }

    public ItemIdentificationConfig getItemIdentificationConfig() {
        return this.itemIdentificationConfig;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreviewManager() {
        return this.isPreviewManager;
    }

    public void setPreviewManager(boolean isPreviewManager) {
        this.isPreviewManager = isPreviewManager;
    }

    public StorageTabPanel<T, S, ? extends StorageManager<?, ?>> getStorageTabPanel() {
        return this.storageTabPanel;
    }

    public void setStorageTabPanel(StorageTabPanel<T, S, ? extends StorageManager<?, ?>> storageTabPanel) {
        this.storageTabPanel = storageTabPanel;
    }
}

