/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.DurationFormatter;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StoragePanel;
import dev.thource.runelite.dudewheresmystuff.StorageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Storage<T extends StorageType> {
    private static final Logger log = LoggerFactory.getLogger(Storage.class);
    protected final DudeWheresMyStuffPlugin plugin;
    protected final T type;
    protected boolean enabled = true;
    @Nullable
    protected StoragePanel storagePanel;
    @Nullable
    protected String lastSaveString;
    protected long lastUpdated = -1L;

    protected Storage(T type, DudeWheresMyStuffPlugin plugin) {
        this.type = type;
        this.plugin = plugin;
    }

    protected void createComponentPopupMenu(StorageManager<?, ?> storageManager) {
        if (this.type.isAutomatic() || this.storagePanel == null) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.storagePanel.setComponentPopupMenu(popupMenu);
        JMenuItem reset = new JMenuItem("Reset");
        reset.addActionListener(e -> {
            boolean confirmed = DudeWheresMyStuffPlugin.getConfirmation(this.storagePanel, "Are you sure you want to reset your " + this.type.getName() + " data?\nThis cannot be undone.", "Confirm reset");
            if (confirmed) {
                this.deleteData(storageManager);
                this.plugin.getClientThread().invoke(() -> {
                    this.storagePanel.refreshItems();
                    SwingUtilities.invokeLater(() -> {
                        this.storagePanel.update();
                        this.softUpdate();
                        storageManager.getStorageTabPanel().reorderStoragePanels();
                    });
                });
            }
        });
        popupMenu.add(reset);
    }

    public void deleteData(StorageManager<?, ?> storageManager) {
        String profileKey = storageManager.isPreviewManager() ? this.plugin.getPreviewProfileKey() : storageManager.getConfigManager().getRSProfileKey();
        storageManager.getConfigManager().unsetConfiguration("dudewheresmystuff", profileKey, this.getConfigKey(storageManager.getConfigKey()));
        this.reset();
    }

    protected void createStoragePanel(StorageManager<?, ?> storageManager) {
        this.storagePanel = new StoragePanel(this.plugin, this, true, false);
        this.createComponentPopupMenu(storageManager);
    }

    public long getTotalValue() {
        return 0L;
    }

    public boolean onGameTick() {
        return false;
    }

    public boolean onWidgetLoaded(WidgetLoaded widgetLoaded) {
        return false;
    }

    public void onWidgetClosed(WidgetClosed widgetClosed) {
    }

    public boolean onChatMessage(ChatMessage chatMessage) {
        return false;
    }

    public boolean onVarbitChanged() {
        return false;
    }

    public boolean onMenuOptionClicked(MenuOptionClicked menuOption) {
        return false;
    }

    public boolean isWithdrawable() {
        return this.enabled;
    }

    public boolean onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        return false;
    }

    public void reset() {
        this.lastUpdated = -1L;
        this.lastSaveString = null;
        this.enable();
    }

    public void save(ConfigManager configManager, String profileKey, String managerConfigKey) {
        if (!this.type.isAutomatic() && this.lastUpdated == -1L) {
            return;
        }
        String saveString = this.getSaveString();
        if (Objects.equals(this.lastSaveString, saveString)) {
            return;
        }
        this.lastSaveString = saveString;
        configManager.setConfiguration("dudewheresmystuff", profileKey, this.getConfigKey(managerConfigKey), saveString);
    }

    public String getSaveString() {
        return String.join((CharSequence)";", this.getSaveValues());
    }

    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = new ArrayList<String>();
        if (!this.type.isAutomatic()) {
            saveValues.add(SaveFieldFormatter.format(this.lastUpdated));
        }
        return saveValues;
    }

    public void load(ConfigManager configManager, String managerConfigKey, String profileKey) {
        String data = (String)configManager.getConfiguration("dudewheresmystuff", profileKey, this.getConfigKey(managerConfigKey), String.class);
        if (data == null) {
            return;
        }
        this.lastSaveString = data;
        this.loadValues(new ArrayList<String>(Arrays.asList(data.split(";"))));
    }

    protected void loadValues(ArrayList<String> values) {
        if (!this.type.isAutomatic()) {
            this.lastUpdated = SaveFieldLoader.loadLong(values, this.lastUpdated);
        }
    }

    protected String getConfigKey(String managerConfigKey) {
        return managerConfigKey + "." + this.type.getConfigKey();
    }

    public void disable() {
        this.enabled = false;
        if (this.storagePanel != null) {
            SwingUtilities.invokeLater(() -> this.storagePanel.setVisible(false));
        }
    }

    public void disable(boolean isMember, int accountType) {
        if (this.type.isMembersOnly() && !isMember || this.type.getAccountTypeBlacklist() != null && this.type.getAccountTypeBlacklist().contains(accountType)) {
            this.disable();
        }
    }

    public void enable() {
        this.enabled = true;
        if (this.storagePanel != null) {
            SwingUtilities.invokeLater(() -> this.storagePanel.setVisible(true));
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public void softUpdate() {
        if (this.storagePanel == null) {
            return;
        }
        if (!this.type.isAutomatic()) {
            if (this.lastUpdated == -1L) {
                this.storagePanel.setFooterText("No data");
            } else {
                long timeSinceLastUpdate = System.currentTimeMillis() - this.lastUpdated;
                this.storagePanel.setFooterText("Updated " + DurationFormatter.format(Math.abs(timeSinceLastUpdate)) + " ago");
            }
        }
    }

    public List<ItemStack> getItems() {
        return new ArrayList<ItemStack>();
    }

    public long getItemCount(int canonicalId) {
        return this.getItems().stream().filter(stack -> stack.getCanonicalId() == canonicalId).mapToLong(ItemStack::getQuantity).sum();
    }

    public DudeWheresMyStuffPlugin getPlugin() {
        return this.plugin;
    }

    public T getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public StoragePanel getStoragePanel() {
        return this.storagePanel;
    }

    @Nullable
    public String getLastSaveString() {
        return this.lastSaveString;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }
}

