/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public enum Seed {
    POTATO(5318, "Potato seed"),
    ONION(5319, "Onion seed"),
    CABBAGE(5324, "Cabbage seed"),
    TOMATO(5322, "Tomato seed"),
    SWEETCORN(5320, "Sweetcorn seed"),
    STRAWBERRY(5323, "Strawberry seed"),
    WATERMELON(5321, "Watermelon seed"),
    SNAPE_GRASS(22879, "Snape grass seed"),
    MARIGOLD(5096, "Marigold seed"),
    ROSEMARY(5097, "Rosemary seed"),
    NASTURTIUM(5098, "Nasturtium seed"),
    WOAD(5099, "Woad seed"),
    LIMPWURT(5100, "Limpwurt seed"),
    WHITE_LILY(22887, "White lily seed"),
    GUAM(5291, "Guam seed"),
    MARRENTILL(5292, "Marrentill seed"),
    TARROMIN(5293, "Tarromin seed"),
    HARRALANDER(5294, "Harralander seed"),
    GOUT_TUBER(6311, "Gout tuber"),
    RANARR(5295, "Ranarr seed"),
    TOADFLAX(5296, "Toadflax seed"),
    IRIT(5297, "Irit seed"),
    AVANTOE(5298, "Avantoe seed"),
    KWUARM(5299, "Kwuarm seed"),
    SNAPDRAGON(5300, "Snapdragon seed"),
    CADANTINE(5301, "Cadantine seed"),
    LANTADYME(5302, "Lantadyme seed"),
    DWARF_WEED(5303, "Dwarf weed seed"),
    TORSTOL(5304, "Torstol seed"),
    BARLEY(5305, "Barley seed"),
    HAMMERSTONE(5307, "Hammerstone seed"),
    ASGARNIAN(5308, "Asgarnian seed"),
    JUTE(5306, "Jute seed"),
    YANILLIAN(5309, "Yanillian seed"),
    KRANDORIAN(5310, "Krandorian seed"),
    WILDBLOOD(5311, "Wildblood seed"),
    REDBERRY(5101, "Redberry seed"),
    CADAVABERRY(5102, "Cadavaberry seed"),
    DWELLBERRY(5103, "Dwellberry seed"),
    JANGERBERRY(5104, "Jangerberry seed"),
    WHITEBERRY(5105, "Whiteberry seed"),
    POISON_IVY(5106, "Poison ivy seed"),
    ACORN(5312, "Acorn"),
    WILLOW(5313, "Willow seed"),
    MAPLE(5314, "Maple seed"),
    YEW(5315, "Yew seed"),
    MAGIC(5316, "Magic seed"),
    APPLE(5283, "Apple tree seed"),
    BANANA(5284, "Banana tree seed"),
    ORANGE(5285, "Orange tree seed"),
    CURRY(5286, "Curry tree seed"),
    PINEAPPLE(5287, "Pineapple seed"),
    PAPAYA(5288, "Papaya tree seed"),
    PALM(5289, "Palm tree seed"),
    DRAGONFRUIT(22877, "Dragonfruit tree seed"),
    SEAWEED(21490, "Seaweed spore"),
    GRAPE(13657, "Grape seed"),
    MUSHROOM(5282, "Mushroom spore"),
    BELLADONNA(5281, "Belladonna seed"),
    HESPORI(22875, "Hespori seed"),
    KRONOS(22885, "Kronos seed"),
    IASOR(22883, "Iasor seed"),
    ATTAS(22881, "Attas seed"),
    TEAK(21486, "Teak seed"),
    MAHOGANY(21488, "Mahogany seed"),
    CALQUAT(5290, "Calquat tree seed"),
    CRYSTAL(23661, "Crystal acorn"),
    SPIRIT(5317, "Spirit seed"),
    CELASTRUS(22869, "Celastrus seed"),
    REDWOOD(22871, "Redwood tree seed"),
    CACTUS(5280, "Cactus seed"),
    POTATO_CACTUS(22873, "Potato cactus seed");

    private static final Map<String, Seed> FROM_NAME;
    private final int itemId;
    private final String name;

    public static Optional<Seed> findByName(String name) {
        return Optional.ofNullable(FROM_NAME.get(name.toLowerCase(Locale.ROOT)));
    }

    private Seed(int itemId, String name) {
        this.itemId = itemId;
        this.name = name;
    }

    public int getItemId() {
        return this.itemId;
    }

    public String getName() {
        return this.name;
    }

    static {
        ImmutableMap.Builder nameMapBuilder = new ImmutableMap.Builder();
        for (Seed seed : Seed.values()) {
            nameMapBuilder.put((Object)seed.getName().toLowerCase(Locale.ROOT), (Object)seed);
        }
        FROM_NAME = nameMapBuilder.build();
    }
}

