/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.EnhancedSwingUtilities;
import dev.thource.runelite.dudewheresmystuff.SearchStorageManager;
import dev.thource.runelite.dudewheresmystuff.SearchStoragePanel;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StorageManagerManager;
import dev.thource.runelite.dudewheresmystuff.StoragePanel;
import dev.thource.runelite.dudewheresmystuff.StorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.StorageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.IconTextField;

class SearchTabPanel
extends StorageTabPanel<StorageType, Storage<StorageType>, StorageManager<StorageType, Storage<StorageType>>> {
    private static final String EMPTY_SEARCH_TEXT = "<html>Type at least 3 characters in the search bar to find your stuff</html>";
    private static final String NO_RESULTS_TEXT = "<html>No items found for your search criteria</html>";
    private final IconTextField searchBar;
    private final transient StorageManagerManager storageManagerManager;
    private final JLabel searchStatusLabel;
    private final JPanel searchStatusPanel;

    SearchTabPanel(DudeWheresMyStuffPlugin plugin, StorageManagerManager storageManagerManager) {
        super(plugin, new SearchStorageManager(plugin));
        this.storageManagerManager = storageManagerManager;
        this.searchBar = new IconTextField();
        this.searchBar.setIcon(IconTextField.Icon.SEARCH);
        this.searchBar.setPreferredSize(new Dimension(this.getWidth(), 30));
        this.searchBar.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchBar.setHoverBackgroundColor(ColorScheme.DARK_GRAY_HOVER_COLOR);
        this.searchBar.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchTabPanel.this.onSearchBarChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchTabPanel.this.onSearchBarChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchTabPanel.this.onSearchBarChanged();
            }
        });
        JPanel searchBarContainer = new JPanel();
        searchBarContainer.setLayout(new BoxLayout(searchBarContainer, 1));
        searchBarContainer.setBorder(new EmptyBorder(6, 0, 2, 0));
        searchBarContainer.add((Component)this.searchBar);
        this.searchStatusLabel = new JLabel(EMPTY_SEARCH_TEXT);
        this.searchStatusLabel.setFont(FontManager.getRunescapeFont());
        this.searchStatusLabel.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.searchStatusLabel.setVerticalAlignment(0);
        this.searchStatusLabel.setHorizontalAlignment(0);
        this.searchStatusPanel = new JPanel(new BorderLayout());
        this.searchStatusPanel.setBorder(new EmptyBorder(7, 7, 7, 7));
        this.searchStatusPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.searchStatusPanel.add(this.searchStatusLabel);
        this.add((Component)searchBarContainer, 1);
        this.add((Component)this.searchStatusPanel, 2);
    }

    private void onSearchBarChanged() {
        if (this.searchBar.getText().length() >= 3) {
            this.searchStatusPanel.setVisible(false);
            this.plugin.getClientThread().invoke(() -> {
                this.storagePanels.forEach(panel -> {
                    ((SearchStoragePanel)panel).setSearchText(this.searchBar.getText());
                    panel.refreshItems();
                });
                SwingUtilities.invokeLater(() -> {
                    this.storagePanels.forEach(StoragePanel::update);
                    this.reorderStoragePanels();
                    if (this.storagePanelContainer.getComponentCount() == 0) {
                        this.searchStatusLabel.setText(NO_RESULTS_TEXT);
                        this.searchStatusPanel.setVisible(true);
                    }
                });
            });
        } else {
            this.searchStatusLabel.setText(EMPTY_SEARCH_TEXT);
            this.searchStatusPanel.setVisible(true);
            EnhancedSwingUtilities.fastRemoveAll(this.storagePanelContainer);
            this.storagePanelContainer.revalidate();
        }
        this.softUpdate();
    }

    @Override
    public void reorderStoragePanels() {
        EnhancedSwingUtilities.fastRemoveAll(this.storagePanelContainer);
        this.storagePanels.stream().filter(panel -> !panel.getItemBoxes().isEmpty()).sorted(Comparator.comparing(panel -> panel.getStorage().getName())).forEach(this.storagePanelContainer::add);
        this.storagePanelContainer.revalidate();
    }

    @Override
    protected Comparator<Storage<StorageType>> getStorageSorter() {
        return Comparator.comparing(Storage::getName);
    }

    @Override
    public void softUpdate() {
        List<Storage> storages = this.storageManagerManager.getStorages().filter(Storage::isEnabled).collect(Collectors.toList());
        storages.forEach(storage -> {
            if (this.storagePanels.stream().noneMatch(panel -> panel.getStorage() == storage)) {
                this.storagePanels.add(new SearchStoragePanel(this.plugin, (Storage<?>)storage));
            }
        });
        ListIterator iterator = this.storagePanels.listIterator();
        while (iterator.hasNext()) {
            Storage<?> storage2 = ((StoragePanel)iterator.next()).getStorage();
            if (storages.contains(storage2)) continue;
            iterator.remove();
        }
        this.storagePanels.stream().filter(panel -> panel.getParent() != null && panel.getStorage().getStoragePanel() != null).forEach(panel -> {
            panel.getStorage().softUpdate();
            StoragePanel sourcePanel = panel.getStorage().getStoragePanel();
            panel.setTitle(sourcePanel.getTitle());
            panel.setTitleToolTip(sourcePanel.getTitleToolTip());
            panel.setSubTitle(sourcePanel.getSubTitle());
            panel.setFooterText(sourcePanel.getFooterText());
        });
        super.softUpdate();
    }

    public void refreshItemSortMode() {
        this.plugin.getClientThread().invoke(() -> this.storagePanels.forEach(panel -> {
            panel.refreshItems();
            SwingUtilities.invokeLater(panel::update);
        }));
    }

    public IconTextField getSearchBar() {
        return this.searchBar;
    }
}

