/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageType;
import dev.thource.runelite.dudewheresmystuff.death.DeathbankType;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageType;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.Menagerie;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageType;
import dev.thource.runelite.dudewheresmystuff.stash.StashUnit;
import dev.thource.runelite.dudewheresmystuff.world.Leprechaun;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveMigrator {
    private static final Logger log = LoggerFactory.getLogger(SaveMigrator.class);
    private static final String PREFIX_COINS = "coins.";
    private static final String PREFIX_CARRYABLE = "carryable.";
    private static final String PREFIX_POH = "poh.";
    private static final String PREFIX_MINIGAMES = "minigames.";
    private static final String PREFIX_WORLD = "world.";
    private final ConfigManager configManager;
    private final String rsProfileKey;

    public SaveMigrator(ConfigManager configManager, String rsProfileKey) {
        this.configManager = configManager;
        this.rsProfileKey = rsProfileKey;
    }

    void migrate() {
        log.info("Migrating data for profile: " + this.rsProfileKey);
        HashMap<String, String> map = new HashMap<String, String>();
        this.migrateCoins(map);
        this.migrateCarryables(map);
        this.migrateDeaths(map);
        this.migrateMinigames(map);
        this.migratePlayerOwnedHouse(map);
        this.migrateStashes(map);
        this.migrateWorld(map);
        map.forEach((key, value) -> this.configManager.setConfiguration("dudewheresmystuff", this.rsProfileKey, key, value));
        this.configManager.setConfiguration("dudewheresmystuff", this.rsProfileKey, "saveMigrated", (Object)true);
        log.info("Profile data migrated!");
    }

    private void migrateCoins(Map<String, String> map) {
        this.stripLastUpdated(map, PREFIX_COINS + CoinsStorageType.NMZ.getConfigKey());
        this.stripLastUpdated(map, PREFIX_COINS + CoinsStorageType.LMS.getConfigKey());
        this.stripLastUpdated(map, PREFIX_COINS + CoinsStorageType.BF.getConfigKey());
        this.stripLastUpdated(map, PREFIX_COINS + CoinsStorageType.INVENTORY.getConfigKey());
    }

    private void migrateCarryables(Map<String, String> map) {
        this.simpleItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.INVENTORY.getConfigKey(), true);
        this.simpleItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.EQUIPMENT.getConfigKey(), true);
        this.simpleItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.LOOTING_BAG.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.SEED_BOX.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.RUNE_POUCH.getConfigKey(), true);
        this.staticItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.BOTTOMLESS_BUCKET.getConfigKey());
        this.staticItemsMigration(map, PREFIX_CARRYABLE + CarryableStorageType.PLANK_SACK.getConfigKey());
    }

    private void migrateDeaths(Map<String, String> map) {
        this.migrateDeathpiles(map);
        this.migrateDeathbanks(map);
    }

    private void migrateDeathpiles(Map<String, String> map) {
        String oldValue = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, "death.deathpiles");
        if (oldValue == null) {
            return;
        }
        for (String deathpileData : oldValue.split("\\$")) {
            String[] deathpileDatas = deathpileData.split(";");
            if (deathpileDatas.length < 3) continue;
            UUID uuid = UUID.randomUUID();
            map.put("death.deathpile." + uuid, deathpileDatas[2].replace(",", "x").replace("=", ",") + ";" + uuid + ";" + deathpileDatas[1] + ";true;" + deathpileDatas[0]);
        }
    }

    private void migrateDeathbanks(Map<String, String> map) {
        String lostDeathbanksData;
        String[] deathbankDatas;
        String currentDeathbankData = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, "death.deathbank");
        if (currentDeathbankData != null && (deathbankDatas = currentDeathbankData.split(";")).length >= 4) {
            UUID uuid = UUID.randomUUID();
            map.put("death.deathbank." + uuid, deathbankDatas[2] + ";" + deathbankDatas[3].replace(",", "x").replace("=", ",") + ";" + uuid + ";" + deathbankDatas[1] + ";-1;" + this.getDeathbankType(deathbankDatas[0]));
        }
        if ((lostDeathbanksData = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, "death.lostdeathbanks")) != null) {
            for (String lostDeathbankData : lostDeathbanksData.split("\\$")) {
                String[] deathbankDatas2 = lostDeathbankData.split(";");
                if (deathbankDatas2.length < 3) continue;
                UUID uuid = UUID.randomUUID();
                map.put("death.deathbank." + uuid, deathbankDatas2[1] + ";" + deathbankDatas2[2].replace(",", "x").replace("=", ",") + ";" + uuid + ";false;" + deathbankDatas2[1] + ";" + this.getDeathbankType(deathbankDatas2[0]));
            }
        }
    }

    private void migrateMinigames(Map<String, String> map) {
        this.minigamePointsMigration(map, PREFIX_MINIGAMES + MinigamesStorageType.MAGE_TRAINING_ARENA.getConfigKey());
        this.minigamePointsMigration(map, PREFIX_MINIGAMES + MinigamesStorageType.TITHE_FARM.getConfigKey());
        this.minigamePointsMigration(map, PREFIX_MINIGAMES + MinigamesStorageType.NIGHTMARE_ZONE.getConfigKey());
        this.minigamePointsMigration(map, PREFIX_MINIGAMES + MinigamesStorageType.BARBARIAN_ASSAULT.getConfigKey());
        this.minigamePointsMigration(map, PREFIX_MINIGAMES + MinigamesStorageType.GUARDIANS_OF_THE_RIFT.getConfigKey());
    }

    private void migratePlayerOwnedHouse(Map<String, String> map) {
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.ARMOUR_CASE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.CAPE_RACK.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.FANCY_DRESS_BOX.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.MAGIC_WARDROBE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_BEGINNER.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_EASY.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_MEDIUM.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_HARD.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_ELITE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.TREASURE_CHEST_MASTER.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_POH + PlayerOwnedHouseStorageType.MENAGERIE.getConfigKey(), false);
        String menagerieData = map.get(PREFIX_POH + PlayerOwnedHouseStorageType.MENAGERIE.getConfigKey());
        if (menagerieData == null) {
            return;
        }
        String[] menagerieDataSplit = menagerieData.split(";");
        if (menagerieDataSplit.length < 3) {
            return;
        }
        int petBits1 = 0;
        int petBits2 = 0;
        block0: for (String itemStackData : menagerieDataSplit[2].split(",")) {
            int itemId = Integer.parseInt(itemStackData.split("x")[0]);
            int bitId = 0;
            for (List<Integer> itemIds : Menagerie.VARPLAYER_BITS_TO_ITEM_IDS_LIST) {
                int itemIndex = itemIds.indexOf(itemId);
                if (itemIndex != -1) {
                    if (bitId == 0) {
                        petBits1 |= 1 << itemIndex;
                        continue block0;
                    }
                    petBits2 |= 1 << itemIndex;
                    continue block0;
                }
                ++bitId;
            }
        }
        map.put(PREFIX_POH + PlayerOwnedHouseStorageType.MENAGERIE.getConfigKey(), menagerieDataSplit[0] + ";" + menagerieDataSplit[1] + ";" + petBits1 + ";" + petBits2);
    }

    private void migrateStashes(Map<String, String> map) {
        for (StashUnit stashUnit : StashUnit.values()) {
            this.simpleItemsMigration(map, "stash." + stashUnit.getStashUnitData().getObjectId(), false);
        }
    }

    private void migrateWorld(Map<String, String> map) {
        this.simpleItemsMigration(map, PREFIX_WORLD + WorldStorageType.LOG_STORAGE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_WORLD + WorldStorageType.BLAST_FURNACE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_WORLD + WorldStorageType.BANK.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_WORLD + WorldStorageType.GROUP_STORAGE.getConfigKey(), false);
        this.simpleItemsMigration(map, PREFIX_WORLD + WorldStorageType.LEPRECHAUN.getConfigKey(), true);
        String leprechaunData = map.get(PREFIX_WORLD + WorldStorageType.LEPRECHAUN.getConfigKey());
        if (leprechaunData == null) {
            return;
        }
        List itemIds = Arrays.stream(leprechaunData.split(",")).map(is -> Integer.parseInt(is.split("x")[0])).collect(Collectors.toList());
        List itemQuantities = Arrays.stream(leprechaunData.split(",")).map(is -> Long.parseLong(is.split("x")[1])).collect(Collectors.toList());
        int wateringCanIndex = 0;
        if ((Long)itemQuantities.get(4) > 0L) {
            wateringCanIndex = Arrays.stream(Leprechaun.getWateringCanIds()).boxed().collect(Collectors.toList()).indexOf(itemIds.get(4));
        }
        map.put(PREFIX_WORLD + WorldStorageType.LEPRECHAUN.getConfigKey(), itemQuantities.stream().map(Object::toString).collect(Collectors.joining(",")) + ";" + ((Integer)itemIds.get(3) == 7409 ? "1" : "0") + ";" + wateringCanIndex);
    }

    private String stripLastUpdated(String data) {
        return data.substring(data.indexOf(";") + 1);
    }

    private void stripLastUpdated(Map<String, String> map, String configKey) {
        String oldValue = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, configKey);
        if (oldValue == null) {
            return;
        }
        map.put(configKey, this.stripLastUpdated(oldValue));
    }

    private void simpleItemsMigration(Map<String, String> map, String configKey, boolean removeLastUpdated) {
        String oldValue = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, configKey);
        if (oldValue == null) {
            return;
        }
        if (removeLastUpdated) {
            oldValue = this.stripLastUpdated(oldValue);
        }
        map.put(configKey, oldValue.replace(",", "x").replace("=", ","));
    }

    private void staticItemsMigration(Map<String, String> map, String configKey) {
        String oldValue = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, configKey);
        if (oldValue == null) {
            return;
        }
        String[] parts = oldValue.split(";", 2);
        map.put(configKey, parts[0] + ";" + parts[1].replace(";", ","));
    }

    private void minigamePointsMigration(Map<String, String> map, String configKey) {
        String oldValue = this.configManager.getConfiguration("dudewheresmystuff", this.rsProfileKey, configKey);
        if (oldValue == null) {
            return;
        }
        map.put(configKey, oldValue.replace("=", ","));
    }

    private DeathbankType getDeathbankType(String deathbankData) {
        switch (deathbankData) {
            case "hydra": {
                return DeathbankType.HYDRA;
            }
            case "guardians": {
                return DeathbankType.GUARDIANS;
            }
            case "sepulchre": {
                return DeathbankType.SEPULCHRE;
            }
            case "hespori": {
                return DeathbankType.HESPORI;
            }
            case "mimic": {
                return DeathbankType.MIMIC;
            }
            case "nex": {
                return DeathbankType.NEX;
            }
            case "nightmare": {
                return DeathbankType.NIGHTMARE;
            }
            case "phosani": {
                return DeathbankType.PHOSANI;
            }
            case "tob": {
                return DeathbankType.TOB;
            }
            case "volcanicmine": {
                return DeathbankType.VOLCANIC_MINE;
            }
            case "vorkath": {
                return DeathbankType.VORKATH;
            }
            case "zulrah": {
                return DeathbankType.ZULRAH;
            }
            case "questds2": {
                return DeathbankType.QUEST_DS2;
            }
            case "questatoh": {
                return DeathbankType.QUEST_ATOH;
            }
            case "questsotf": {
                return DeathbankType.QUEST_SOTF;
            }
            case "questsote": {
                return DeathbankType.QUEST_SOTE;
            }
            case "questtfe": {
                return DeathbankType.QUEST_TFE;
            }
        }
        return DeathbankType.UNKNOWN;
    }
}

