/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.common.collect.ImmutableMap;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPanel;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.FakeDataService;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.OverviewItemPanel;
import dev.thource.runelite.dudewheresmystuff.StorageManagerManager;
import dev.thource.runelite.dudewheresmystuff.Tab;
import dev.thource.runelite.dudewheresmystuff.TabContentPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfile;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OverviewTabPanel
extends TabContentPanel {
    private static final Logger log = LoggerFactory.getLogger(OverviewTabPanel.class);
    private static final String LOGGED_OUT_SUMMARY = "Log in to find your stuff!";
    private static final String GP_TOTAL = "%,d gp";
    private static final String DELETE_SAVE_WARNING = "Are you sure you want to delete your save data?\nThis cannot be undone.";
    private static final String DELETE_ALL_DEATHPILES_WARNING = "Are you sure you want to delete all of your deathpiles/graves (including any active ones)?\nThis cannot be undone.";
    private static final String DELETE_ALL_EXPIRED_DEATHPILES_WARNING = "Are you sure you want to delete all of your expired deathpiles/graves?\nThis cannot be undone.";
    private static final String DELETE_ALL_DEATHBANKS_WARNING = "Are you sure you want to delete all of your deathbanks (including any active ones)?\nThis cannot be undone.";
    private static final String DELETE_ALL_LOST_DEATHBANKS_WARNING = "Are you sure you want to delete all of your lost deathbanks?\nThis cannot be undone.";
    private static final String DELETE_ALL_SAVE_WARNING = "Are you sure you want to delete ALL of your save data?\nThis cannot be undone.";
    private static final String DELETE_ALL_SAVE_FINAL_WARNING = "Are you REALLY sure you want to delete ALL of your save data?\nThis REALLY cannot be undone.";
    private static final String EXPORT_ITEMS_TEXT = "Export items to CSV";
    private static final String CONFIRM_DELETION_TEXT = "Confirm deletion";
    private final Map<Tab, OverviewItemPanel> overviews;
    private final OverviewItemPanel summaryOverview;
    private final DudeWheresMyStuffPanel pluginPanel;
    private final transient DudeWheresMyStuffPlugin plugin;
    private final transient StorageManagerManager storageManagerManager;

    OverviewTabPanel(DudeWheresMyStuffPlugin plugin, DudeWheresMyStuffPanel pluginPanel, ItemManager itemManager, final ConfigManager configManager, StorageManagerManager storageManagerManager, boolean developerMode) {
        this.pluginPanel = pluginPanel;
        this.plugin = plugin;
        this.storageManagerManager = storageManagerManager;
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.summaryOverview = new OverviewItemPanel(itemManager, null, () -> false, 20770, 1, LOGGED_OUT_SUMMARY);
        this.add(this.summaryOverview);
        this.add(Box.createVerticalStrut(8));
        if (developerMode) {
            this.summaryOverview.addMouseListener(new MouseAdapter(){
                int clicks;
                long lastClick;

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (System.currentTimeMillis() - this.lastClick < 500L) {
                        if (++this.clicks == 5) {
                            this.clicks = 0;
                            FakeDataService.createData(configManager);
                            log.info("Created fake data!");
                            OverviewTabPanel.this.resetSummaryContextMenu();
                        }
                    } else {
                        this.clicks = 1;
                    }
                    this.lastClick = System.currentTimeMillis();
                }
            });
        }
        this.resetSummaryContextMenu();
        this.overviews = (Map)Tab.TABS.stream().filter(v -> v != Tab.OVERVIEW && v != Tab.SEARCH).collect(ImmutableMap.toImmutableMap(Function.identity(), t -> {
            OverviewItemPanel p = new OverviewItemPanel(itemManager, pluginPanel, (Tab)((Object)t), t.getName());
            this.add(p);
            this.add(Box.createVerticalStrut(8));
            p.setVisible(false);
            return p;
        }));
        this.createDeathStoragePopupMenu();
    }

    private void createDeathStoragePopupMenu() {
        JMenuItem deleteAllDeathpiles = new JMenuItem("Delete all deathpiles/graves");
        deleteAllDeathpiles.addActionListener(e -> {
            if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_DEATHPILES_WARNING, CONFIRM_DELETION_TEXT)) {
                this.storageManagerManager.getDeathStorageManager().deleteExpiringDeathStorages(true);
            }
        });
        JMenuItem deleteExpiredDeathpiles = new JMenuItem("Delete expired deathpiles/graves");
        deleteExpiredDeathpiles.addActionListener(e -> {
            if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_EXPIRED_DEATHPILES_WARNING, CONFIRM_DELETION_TEXT)) {
                this.storageManagerManager.getDeathStorageManager().deleteExpiringDeathStorages(false);
            }
        });
        JMenuItem deleteAllDeathbanks = new JMenuItem("Delete all deathbanks");
        deleteAllDeathbanks.addActionListener(e -> {
            if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_DEATHBANKS_WARNING, CONFIRM_DELETION_TEXT)) {
                this.storageManagerManager.getDeathStorageManager().deleteDeathbanks(true);
            }
        });
        JMenuItem deleteLostDeathbanks = new JMenuItem("Delete lost deathbanks");
        deleteLostDeathbanks.addActionListener(e -> {
            if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_LOST_DEATHBANKS_WARNING, CONFIRM_DELETION_TEXT)) {
                this.storageManagerManager.getDeathStorageManager().deleteDeathbanks(false);
            }
        });
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(deleteAllDeathpiles);
        popupMenu.add(deleteExpiredDeathpiles);
        popupMenu.add(deleteAllDeathbanks);
        popupMenu.add(deleteLostDeathbanks);
        this.overviews.get((Object)Tab.DEATH).setComponentPopupMenu(popupMenu);
    }

    @Override
    public void softUpdate() {
        this.resetSummaryContextMenu();
        if (Objects.equals(this.pluginPanel.getDisplayName(), "")) {
            this.summaryOverview.setTitle(LOGGED_OUT_SUMMARY);
            this.summaryOverview.updateStatus("Right-click to preview data.");
        } else {
            this.summaryOverview.setTitle(this.pluginPanel.getDisplayName());
            if (this.pluginPanel.isPreviewPanel() && !Objects.equals(this.pluginPanel.getDisplayName(), "Thource")) {
                this.summaryOverview.updateStatus(String.format("<html><body style=\"margin: 0; padding: 0;\">%,d gp<br>Right-click to exit preview.</body></html>", this.getTotalValue()));
            } else {
                this.summaryOverview.updateStatus(String.format(GP_TOTAL, this.getTotalValue()));
            }
        }
        this.overviews.get((Object)Tab.DEATH).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getDeathStorageManager().getTotalValue()));
        this.overviews.get((Object)Tab.COINS).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getCoinsStorageManager().getTotalValue()));
        this.overviews.get((Object)Tab.CARRYABLE_STORAGE).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getCarryableStorageManager().getTotalValue()));
        this.overviews.get((Object)Tab.STASH_UNITS).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getStashStorageManager().getTotalValue()));
        this.overviews.get((Object)Tab.POH_STORAGE).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getPlayerOwnedHouseStorageManager().getTotalValue()));
        this.overviews.get((Object)Tab.WORLD).updateStatus(String.format(GP_TOTAL, this.storageManagerManager.getWorldStorageManager().getTotalValue()));
    }

    private long getTotalValue() {
        return this.storageManagerManager.getItems().stream().mapToLong(ItemStack::getTotalGePrice).sum();
    }

    void resetSummaryContextMenu() {
        SwingUtilities.invokeLater(() -> {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.summaryOverview.setComponentPopupMenu(popupMenu);
            if (this.pluginPanel.isPreviewPanel()) {
                this.addDeleteDeathbankMenuOption(popupMenu);
                this.addExitPreviewModeMenuOption(popupMenu);
            } else {
                this.addPreviewModeMenuOption(popupMenu);
                this.addDeleteAllDataMenuOption(popupMenu);
            }
            this.addExportToCsvMenuOption(popupMenu);
        });
    }

    private void addExportToCsvMenuOption(JPopupMenu popupMenu) {
        if (!Objects.equals(this.pluginPanel.getDisplayName(), "")) {
            JMenuItem exportItems = new JMenuItem(EXPORT_ITEMS_TEXT);
            exportItems.addActionListener(e -> this.storageManagerManager.exportItems());
            popupMenu.add(exportItems);
        }
    }

    private void addDeleteAllDataMenuOption(JPopupMenu popupMenu) {
        if (this.plugin.getProfilesWithData().findAny().isPresent()) {
            popupMenu.add(new JPopupMenu.Separator());
            JMenuItem deleteAllData = new JMenuItem("Delete all data");
            deleteAllData.addActionListener(e -> {
                if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_SAVE_WARNING, CONFIRM_DELETION_TEXT) && DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_ALL_SAVE_FINAL_WARNING, CONFIRM_DELETION_TEXT)) {
                    this.plugin.deleteAllData();
                    this.resetSummaryContextMenu();
                }
            });
            popupMenu.add(deleteAllData);
        }
    }

    private void addExitPreviewModeMenuOption(JPopupMenu popupMenu) {
        JMenuItem exitPreviewMode = new JMenuItem("Exit preview mode");
        exitPreviewMode.addActionListener(e -> this.plugin.disablePreviewMode(false));
        popupMenu.add(exitPreviewMode);
    }

    private void addDeleteDeathbankMenuOption(JPopupMenu popupMenu) {
        JMenuItem clearDeathbank = new JMenuItem("Delete data");
        clearDeathbank.addActionListener(e -> {
            if (DudeWheresMyStuffPlugin.getConfirmation(this, DELETE_SAVE_WARNING, CONFIRM_DELETION_TEXT)) {
                this.plugin.disablePreviewMode(true);
                this.resetSummaryContextMenu();
            }
        });
        popupMenu.add(clearDeathbank);
    }

    private void addPreviewModeMenuOption(JPopupMenu popupMenu) {
        JMenu previewMenu = new JMenu("Preview data");
        this.plugin.getProfilesWithData().filter(runeScapeProfile -> !this.plugin.getDisplayName((RuneScapeProfile)runeScapeProfile).equals(this.pluginPanel.getDisplayName())).forEach(profile -> {
            String displayName = this.plugin.getDisplayName((RuneScapeProfile)profile);
            JMenuItem previewItem = new JMenuItem(displayName);
            previewItem.addActionListener(e -> {
                if (Objects.equals(this.pluginPanel.getDisplayName(), displayName)) {
                    return;
                }
                this.plugin.enablePreviewMode(profile.getKey(), displayName);
            });
            previewMenu.add(previewItem);
        });
        if (previewMenu.getSubElements().length != 0) {
            popupMenu.add(previewMenu);
        }
    }

    public Map<Tab, OverviewItemPanel> getOverviews() {
        return this.overviews;
    }
}

