/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPanel;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.Tab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

class OverviewItemPanel
extends JPanel {
    private static final ImageIcon ARROW_RIGHT_ICON;
    private static final Color HOVER_COLOR;
    private final JPanel textContainer;
    private final JLabel statusLabel;
    private final JLabel arrowLabel;
    private final transient BooleanSupplier isSelectable;
    private final JLabel titleLabel;
    private boolean isHighlighted;
    @Nullable
    private JButton popupButton;
    private final Container rightContainer;

    OverviewItemPanel(ItemManager itemManager, DudeWheresMyStuffPanel pluginPanel, @Nullable Tab tab, String title) {
        this(itemManager, () -> pluginPanel.switchTab(tab), () -> true, tab != null ? tab.getItemId() : -1, tab != null ? tab.getItemQuantity() : -1, title);
    }

    OverviewItemPanel(ItemManager itemManager, final @Nullable Runnable onTabSwitched, BooleanSupplier isSelectable, int iconItemId, int iconItemQuantity, String title) {
        this.isSelectable = isSelectable;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
        if (iconItemId != -1) {
            JLabel iconLabel = new JLabel();
            iconLabel.setMinimumSize(new Dimension(36, 32));
            itemManager.getImage(iconItemId, iconItemQuantity, false).addTo(iconLabel);
            this.add((Component)iconLabel, "West");
        }
        this.textContainer = new JPanel();
        this.textContainer.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.textContainer.setLayout(new GridLayout(2, 1));
        this.textContainer.setBorder(new EmptyBorder(5, 7, 5, 7));
        if (isSelectable.getAsBoolean()) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    if (onTabSwitched != null) {
                        onTabSwitched.run();
                    }
                    OverviewItemPanel.this.setHighlighted(false);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    OverviewItemPanel.this.setHighlighted(true);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    OverviewItemPanel.this.setHighlighted(true);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    OverviewItemPanel.this.setHighlighted(false);
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){
            private final Component rigidArea = Box.createRigidArea(new Dimension(5, 0));

            @Override
            public void mouseEntered(MouseEvent e) {
                if (OverviewItemPanel.this.popupButton == null) {
                    return;
                }
                OverviewItemPanel.this.rightContainer.add(this.rigidArea);
                OverviewItemPanel.this.rightContainer.add(OverviewItemPanel.this.popupButton);
                OverviewItemPanel.this.revalidate();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (OverviewItemPanel.this.popupButton == null || !OverviewItemPanel.this.isShowing() || OverviewItemPanel.this.getVisibleRect().contains(e.getPoint())) {
                    return;
                }
                OverviewItemPanel.this.rightContainer.remove(this.rigidArea);
                OverviewItemPanel.this.rightContainer.remove(OverviewItemPanel.this.popupButton);
                OverviewItemPanel.this.revalidate();
            }
        });
        this.titleLabel = new JLabel(title);
        this.titleLabel.setForeground(Color.WHITE);
        this.titleLabel.setFont(FontManager.getRunescapeSmallFont());
        this.statusLabel = new JLabel();
        this.statusLabel.setForeground(Color.LIGHT_GRAY);
        this.statusLabel.setFont(FontManager.getRunescapeSmallFont());
        this.textContainer.add(this.titleLabel);
        this.textContainer.add(this.statusLabel);
        this.add((Component)this.textContainer, "Center");
        this.rightContainer = new Container();
        this.rightContainer.setLayout(new BoxLayout(this.rightContainer, 0));
        this.arrowLabel = new JLabel(ARROW_RIGHT_ICON);
        this.arrowLabel.setVisible(isSelectable.getAsBoolean());
        this.rightContainer.add(this.arrowLabel);
        this.add((Component)this.rightContainer, "East");
    }

    @Override
    public void setComponentPopupMenu(JPopupMenu popup) {
        super.setComponentPopupMenu(popup);
        if (popup == null) {
            if (this.popupButton != null) {
                this.rightContainer.remove(this.popupButton);
                this.popupButton = null;
            }
            return;
        }
        if (this.popupButton != null) {
            return;
        }
        this.popupButton = new JButton("\u2026");
        this.popupButton.setPreferredSize(new Dimension(20, -1));
        this.popupButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                OverviewItemPanel.this.getComponentPopupMenu().show(OverviewItemPanel.this.popupButton, mouseEvent.getX(), mouseEvent.getY());
            }
        });
    }

    void updateStatus(String text) {
        this.statusLabel.setText(text);
        this.arrowLabel.setVisible(this.isSelectable.getAsBoolean());
        if (this.isHighlighted && !this.isSelectable.getAsBoolean()) {
            this.setHighlighted(false);
        }
    }

    private void setHighlighted(boolean highlighted) {
        if (highlighted && !this.isSelectable.getAsBoolean()) {
            return;
        }
        this.setBackground(highlighted ? HOVER_COLOR : ColorScheme.DARKER_GRAY_COLOR);
        this.setCursor(new Cursor(highlighted && this.getMousePosition(true) != null ? 12 : 0));
        this.textContainer.setBackground(highlighted ? HOVER_COLOR : ColorScheme.DARKER_GRAY_COLOR);
        this.isHighlighted = highlighted;
    }

    void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    static {
        HOVER_COLOR = ColorScheme.DARKER_GRAY_HOVER_COLOR;
        ARROW_RIGHT_ICON = new ImageIcon(ImageUtil.loadImageResource(DudeWheresMyStuffPlugin.class, (String)"/util/arrow_right.png"));
    }
}

