/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemContainerWatcher;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.SaveFieldFormatter;
import dev.thource.runelite.dudewheresmystuff.SaveFieldLoader;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;

public class ItemStorage<T extends StorageType>
extends Storage<T> {
    @Nullable
    protected int[] varbits = null;
    protected int varbitItemOffset = 0;
    @Nullable
    protected final ItemContainerWatcher itemContainerWatcher;
    protected List<ItemStack> items = new ArrayList<ItemStack>();
    protected boolean hasStaticItems = false;

    protected ItemStorage(T type, DudeWheresMyStuffPlugin plugin) {
        super(type, plugin);
        this.itemContainerWatcher = ItemContainerWatcher.getWatcher(type.getItemContainerId());
    }

    @Override
    public boolean onVarbitChanged() {
        if (this.varbits == null) {
            return false;
        }
        boolean updated = false;
        for (int i = 0; i < this.varbits.length; ++i) {
            int varbit = this.varbits[i];
            ItemStack itemStack = this.items.get(i + this.varbitItemOffset);
            int newPoints = this.plugin.getClient().getVarbitValue(varbit);
            if ((long)newPoints == itemStack.getQuantity()) continue;
            itemStack.setQuantity(newPoints);
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean onGameTick() {
        if (this.itemContainerWatcher != null && this.itemContainerWatcher.wasJustUpdated()) {
            this.items.clear();
            this.items.addAll(this.itemContainerWatcher.getItems());
            this.lastUpdated = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (this.itemContainerWatcher != null || this.type.getItemContainerId() != itemContainerChanged.getContainerId()) {
            return false;
        }
        ItemContainer itemContainer = itemContainerChanged.getItemContainer();
        if (itemContainer == null) {
            return false;
        }
        this.items.clear();
        for (Item item : itemContainer.getItems()) {
            if (item.getId() == -1) {
                this.items.add(new ItemStack(item.getId(), "empty slot", 1L, 0, 0, false));
                continue;
            }
            ItemComposition itemComposition = this.plugin.getItemManager().getItemComposition(item.getId());
            if (itemComposition.getPlaceholderTemplateId() != -1) continue;
            this.items.add(new ItemStack(item.getId(), item.getQuantity(), this.plugin));
        }
        this.lastUpdated = System.currentTimeMillis();
        return true;
    }

    @Override
    protected ArrayList<String> getSaveValues() {
        ArrayList<String> saveValues = super.getSaveValues();
        saveValues.add(SaveFieldFormatter.format(this.items, this.hasStaticItems));
        return saveValues;
    }

    @Override
    protected void loadValues(ArrayList<String> values) {
        super.loadValues(values);
        if (this.hasStaticItems) {
            SaveFieldLoader.loadItemsIntoList(values, this.items);
        } else {
            this.items = SaveFieldLoader.loadItems(values, this.items, this.plugin);
        }
    }

    @Override
    public long getTotalValue() {
        long sum = 0L;
        for (ItemStack item : this.items) {
            sum += item.getTotalGePrice();
        }
        return sum;
    }

    @Override
    public void reset() {
        if (this.hasStaticItems) {
            this.items.forEach(item -> item.setQuantity(0L));
        } else {
            this.items.clear();
        }
        super.reset();
    }

    public long remove(int id, long quantity) {
        if (quantity <= 0L) {
            return 0L;
        }
        long itemsRemoved = 0L;
        Iterator<ItemStack> listIterator = this.items.iterator();
        while (listIterator.hasNext() && quantity > 0L) {
            ItemStack itemStack = listIterator.next();
            if (itemStack.getId() != id) continue;
            long qtyToRemove = Math.min(quantity, itemStack.getQuantity());
            quantity -= qtyToRemove;
            itemsRemoved += qtyToRemove;
            itemStack.setQuantity(itemStack.getQuantity() - qtyToRemove);
            if (itemStack.getQuantity() > 0L) continue;
            listIterator.remove();
        }
        return itemsRemoved;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }
}

