/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorage;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class ItemStackUtils {
    public static final List<Integer> ITEM_IDS_DESTROYED_ON_DEATH = Collections.unmodifiableList(Arrays.asList(11941, 22586, 12789, 12854, 25630, 9096, 9097, 9098, 9099, 9100, 9101, 9102, 9104, 9084, 4202, 6465, 13660, 778, 775, 776, 777, 11259, 11258, 12853, 26503, 26505, 26507, 26509, 26511, 26513, 26515, 25054, 25052, 25050, 25048, 25046, 25044, 25042, 24384, 24382, 24380, 24378, 24376, 24374, 24372, 9626, 9625));

    private ItemStackUtils() {
    }

    public static List<ItemStack> compound(List<ItemStack> itemStacks, boolean compoundUnstackables) {
        ArrayList<ItemStack> compoundedItemStacks = new ArrayList<ItemStack>();
        itemStacks.forEach(itemStack -> {
            if (itemStack.getId() == -1) {
                return;
            }
            boolean wasCompounded = false;
            if (itemStack.isStackable() || compoundUnstackables) {
                for (ItemStack compoundedItemStack : compoundedItemStacks) {
                    if (compoundedItemStack.getId() != itemStack.getId()) continue;
                    compoundedItemStack.setQuantity(compoundedItemStack.getQuantity() + itemStack.getQuantity());
                    wasCompounded = true;
                }
            }
            if (!wasCompounded) {
                compoundedItemStacks.add(new ItemStack((ItemStack)itemStack));
            }
        });
        return compoundedItemStacks;
    }

    public static void addItemStack(List<ItemStack> items, ItemStack itemToAdd) {
        if (itemToAdd.isStackable()) {
            for (ItemStack item : items) {
                if (item.getId() != itemToAdd.getId()) continue;
                item.setQuantity(item.getQuantity() + itemToAdd.getQuantity());
                return;
            }
        }
        ListIterator<ItemStack> listIterator = items.listIterator();
        while (listIterator.hasNext()) {
            ItemStack item;
            item = listIterator.next();
            if (item.getId() != -1) continue;
            listIterator.set(itemToAdd);
            return;
        }
        items.add(itemToAdd);
    }

    public static void removeItemStack(List<ItemStack> items, ItemStack itemToRemove, boolean replaceWithEmpty) {
        if (itemToRemove.getId() == -1) {
            return;
        }
        long quantityToRemove = itemToRemove.getQuantity();
        ListIterator<ItemStack> listIterator = items.listIterator();
        while (listIterator.hasNext() && quantityToRemove > 0L) {
            ItemStack inventoryItem = listIterator.next();
            if (inventoryItem.getId() != itemToRemove.getId()) continue;
            long qtyToRemove = Math.min(quantityToRemove, inventoryItem.getQuantity());
            quantityToRemove -= qtyToRemove;
            inventoryItem.setQuantity(inventoryItem.getQuantity() - qtyToRemove);
            if (inventoryItem.getQuantity() != 0L) continue;
            if (replaceWithEmpty) {
                listIterator.set(new ItemStack(-1, "empty", 1L, 0, 0, false));
                continue;
            }
            listIterator.remove();
        }
    }

    public static void removeItemStack(List<ItemStack> items, ItemStack itemToRemove) {
        ItemStackUtils.removeItemStack(items, itemToRemove, true);
    }

    public static void removeItems(List<ItemStack> itemsToModify, List<ItemStack> itemsToRemove) {
        for (ItemStack itemStack : itemsToRemove) {
            ItemStackUtils.removeItemStack(itemsToModify, itemStack, false);
        }
    }

    public static List<ItemStack> explodeStorageItems(List<ItemStack> itemStacks, CarryableStorageManager carryableStorageManager) {
        ArrayList<ItemStack> explodedItemStacks = new ArrayList<ItemStack>();
        itemStacks.forEach(itemStack -> explodedItemStacks.add(new ItemStack((ItemStack)itemStack)));
        boolean isLootingBagPresent = false;
        ListIterator itemStacksIterator = explodedItemStacks.listIterator();
        while (itemStacksIterator.hasNext()) {
            ItemStack itemStack2 = (ItemStack)itemStacksIterator.next();
            for (CarryableStorage storage : carryableStorageManager.getStorages()) {
                CarryableStorageType storageType = (CarryableStorageType)storage.getType();
                if (storageType == CarryableStorageType.LOOTING_BAG || storageType.getContainerIds().isEmpty() || !storageType.getContainerIds().contains(itemStack2.getId())) continue;
                if (storageType.getEmptyOnDeathVarbit() != -1) {
                    if (storage.getPlugin().getClient().getVarbitValue(storageType.getEmptyOnDeathVarbit()) != 1) continue;
                }
                storage.getItems().forEach(itemStacksIterator::add);
            }
            if (!CarryableStorageType.LOOTING_BAG.getContainerIds().contains(itemStack2.getId())) continue;
            isLootingBagPresent = true;
        }
        if (isLootingBagPresent) {
            carryableStorageManager.getStorages().stream().filter(s -> s.getType() == CarryableStorageType.LOOTING_BAG).findFirst().ifPresent(lootingBag -> explodedItemStacks.addAll(lootingBag.getItems()));
        }
        return explodedItemStacks;
    }

    public static List<ItemStack> filterDestroyedOnDeath(List<ItemStack> itemStacks) {
        ArrayList<ItemStack> filteredItemStacks = new ArrayList<ItemStack>();
        itemStacks.forEach(itemStack -> filteredItemStacks.add(new ItemStack((ItemStack)itemStack)));
        filteredItemStacks.removeIf(itemStack -> ITEM_IDS_DESTROYED_ON_DEATH.contains(itemStack.getId()));
        return filteredItemStacks;
    }
}

