/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemIdentification;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;

public class ItemStack {
    private int id;
    private long quantity;
    private String name;
    private int gePrice;
    private int haPrice;
    private boolean stackable;
    private ItemIdentification itemIdentification;
    private int canonicalId;

    public ItemStack(int id, DudeWheresMyStuffPlugin plugin) {
        this.id = id;
        this.name = "Loading";
        this.quantity = 0L;
        plugin.getClientThread().invoke(() -> this.populateFromComposition(plugin));
    }

    public ItemStack(int id, long quantity, DudeWheresMyStuffPlugin plugin) {
        this(id, plugin);
        this.quantity = quantity;
    }

    public ItemStack(ItemStack itemStack) {
        this(itemStack.getId(), itemStack.getName(), itemStack.getQuantity(), itemStack.getGePrice(), itemStack.getHaPrice(), itemStack.isStackable());
        this.itemIdentification = itemStack.getItemIdentification();
        this.canonicalId = itemStack.canonicalId;
    }

    public ItemStack(int id, String name, long quantity, int gePrice, int haPrice, boolean stackable) {
        this.id = id;
        this.name = name;
        this.quantity = quantity;
        this.gePrice = gePrice;
        this.haPrice = haPrice;
        this.stackable = stackable;
        this.canonicalId = id;
    }

    private boolean populateFromComposition(DudeWheresMyStuffPlugin plugin) {
        if (plugin.getClient().getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            return false;
        }
        ItemManager itemManager = plugin.getItemManager();
        ItemComposition composition = itemManager.getItemComposition(this.id);
        this.name = composition.getName();
        this.gePrice = itemManager.getItemPrice(this.id);
        this.haPrice = composition.getHaPrice();
        this.stackable = composition.isStackable();
        this.canonicalId = itemManager.canonicalize(this.id);
        this.itemIdentification = ItemIdentification.get(this.canonicalId);
        return true;
    }

    long getTotalGePrice() {
        return (long)this.gePrice * this.quantity;
    }

    long getTotalHaPrice() {
        return (long)this.haPrice * this.quantity;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setId(int id, DudeWheresMyStuffPlugin plugin) {
        this.id = id;
        this.populateFromComposition(plugin);
    }

    public void stripPrices() {
        this.haPrice = 0;
        this.gePrice = 0;
    }

    public int getId() {
        return this.id;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String getName() {
        return this.name;
    }

    public int getGePrice() {
        return this.gePrice;
    }

    public int getHaPrice() {
        return this.haPrice;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public ItemIdentification getItemIdentification() {
        return this.itemIdentification;
    }

    public int getCanonicalId() {
        return this.canonicalId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemStack)) {
            return false;
        }
        ItemStack other = (ItemStack)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        return this.getQuantity() == other.getQuantity();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemStack;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        long $quantity = this.getQuantity();
        result = result * 59 + (int)($quantity >>> 32 ^ $quantity);
        return result;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }
}

