/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffConfig;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StoredItemCountTooltipMode;
import java.awt.Graphics2D;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.config.Keybind;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class ItemCountOverlay
extends WidgetItemOverlay {
    private final Client client;
    private final DudeWheresMyStuffPlugin plugin;
    private final DudeWheresMyStuffConfig dudeWheresMyStuffConfig;
    private final TooltipManager tooltipManager;
    private boolean keybindPressed;

    @Inject
    ItemCountOverlay(Client client, DudeWheresMyStuffPlugin dudeWheresMyStuffPlugin, DudeWheresMyStuffConfig dudeWheresMyStuffConfig, TooltipManager tooltipManager) {
        this.client = client;
        this.plugin = dudeWheresMyStuffPlugin;
        this.dudeWheresMyStuffConfig = dudeWheresMyStuffConfig;
        this.tooltipManager = tooltipManager;
        this.showOnInventory();
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem widgetItem) {
        if (this.dudeWheresMyStuffConfig.storedItemCountTooltip() == StoredItemCountTooltipMode.OFF) {
            return;
        }
        if (this.dudeWheresMyStuffConfig.storedItemCountTooltipKeybind().getKeyCode() != Keybind.NOT_SET.getKeyCode() || this.dudeWheresMyStuffConfig.storedItemCountTooltipKeybind().getModifiers() != Keybind.NOT_SET.getModifiers() && !this.keybindPressed) {
            return;
        }
        Point mousePos = this.client.getMouseCanvasPosition();
        if (!widgetItem.getCanvasBounds().contains(mousePos.getX(), mousePos.getY())) {
            return;
        }
        if (this.dudeWheresMyStuffConfig.storedItemCountTooltip() == StoredItemCountTooltipMode.SIMPLE) {
            long count2 = this.plugin.getWithdrawableItemCount(widgetItem.getId());
            this.tooltipManager.add(new Tooltip("Stored: " + String.format("%,d", count2)));
            return;
        }
        Map<Storage<?>, Long> detailedItemCountMap = this.plugin.getDetailedWithdrawableItemCount(widgetItem.getId());
        long total = detailedItemCountMap.values().stream().mapToLong(count -> count).sum();
        Object detailedText = detailedItemCountMap.entrySet().stream().sorted(Comparator.comparingLong(Map.Entry::getValue).reversed()).map(entry -> ((Storage)entry.getKey()).getName() + ": " + String.format("%,d", entry.getValue())).collect(Collectors.joining("</br>"));
        if (detailedItemCountMap.values().size() > 1) {
            detailedText = (String)detailedText + "</br></br>Total: " + String.format("%,d", total);
        }
        this.tooltipManager.add(new Tooltip((String)detailedText));
    }

    public void setKeybindPressed(boolean keybindPressed) {
        this.keybindPressed = keybindPressed;
    }
}

