/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.common.collect.ImmutableMap;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.ItemStackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

public class ItemContainerWatcher {
    static final ItemContainerWatcher inventoryWatcher = new ItemContainerWatcher(InventoryID.INVENTORY.getId());
    static final ItemContainerWatcher lootingBagWatcher = new ItemContainerWatcher(516);
    static final ItemContainerWatcher seedBoxWatcher = new ItemContainerWatcher(573);
    static final ItemContainerWatcher deathsOfficeWatcher = new ItemContainerWatcher(636);
    private static final Map<Integer, ItemContainerWatcher> watcherMap;
    private static final ItemContainerWatcher[] all;
    private static Client client;
    private final int itemContainerId;
    private final List<ItemStack> itemsLastTick = new ArrayList<ItemStack>();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    private boolean justUpdated = false;

    ItemContainerWatcher(int itemContainerId) {
        this.itemContainerId = itemContainerId;
    }

    static void init(Client client) {
        ItemContainerWatcher.client = client;
    }

    static void reset() {
        for (ItemContainerWatcher itemContainerWatcher : all) {
            itemContainerWatcher.itemsLastTick.clear();
            itemContainerWatcher.items.clear();
            itemContainerWatcher.justUpdated = false;
        }
    }

    static void onGameTick(DudeWheresMyStuffPlugin plugin) {
        for (ItemContainerWatcher itemContainerWatcher : all) {
            itemContainerWatcher.gameTick(plugin);
        }
    }

    public static ItemContainerWatcher getWatcher(int itemContainerId) {
        return watcherMap.get(itemContainerId);
    }

    public boolean wasJustUpdated() {
        return this.justUpdated;
    }

    private void gameTick(DudeWheresMyStuffPlugin plugin) {
        this.justUpdated = false;
        this.itemsLastTick.clear();
        this.itemsLastTick.addAll(this.items);
        ItemContainer itemContainer = client.getItemContainer(this.itemContainerId);
        if (itemContainer == null) {
            return;
        }
        this.justUpdated = true;
        this.items.clear();
        this.items.addAll(Arrays.stream(itemContainer.getItems()).map(item -> {
            if (item.getId() == -1) {
                return new ItemStack(-1, "empty", 1L, 0, 0, false);
            }
            Optional<ItemStack> oldItem = this.itemsLastTick.stream().filter(o -> o.getId() == item.getId()).findFirst();
            if (oldItem.isPresent()) {
                ItemStack newItem = new ItemStack(oldItem.get());
                newItem.setQuantity(item.getQuantity());
                return newItem;
            }
            return new ItemStack(item.getId(), item.getQuantity(), plugin);
        }).collect(Collectors.toList()));
    }

    public List<ItemStack> getItemsAddedLastTick() {
        List<ItemStack> itemsAddedLastTick = this.items.stream().filter(i -> i.getId() != -1).map(ItemStack::new).collect(Collectors.toList());
        ItemStackUtils.removeItems(itemsAddedLastTick, this.itemsLastTick);
        return itemsAddedLastTick;
    }

    public List<ItemStack> getItemsRemovedLastTick() {
        List<ItemStack> itemsRemovedLastTick = this.itemsLastTick.stream().filter(i -> i.getId() != -1).map(ItemStack::new).collect(Collectors.toList());
        ItemStackUtils.removeItems(itemsRemovedLastTick, this.items);
        return itemsRemovedLastTick;
    }

    public static ItemContainerWatcher getInventoryWatcher() {
        return inventoryWatcher;
    }

    public static ItemContainerWatcher getLootingBagWatcher() {
        return lootingBagWatcher;
    }

    public static ItemContainerWatcher getSeedBoxWatcher() {
        return seedBoxWatcher;
    }

    public static ItemContainerWatcher getDeathsOfficeWatcher() {
        return deathsOfficeWatcher;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    static {
        all = new ItemContainerWatcher[]{inventoryWatcher, lootingBagWatcher, seedBoxWatcher, deathsOfficeWatcher};
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (ItemContainerWatcher itemContainerWatcher : all) {
            mapBuilder.put((Object)itemContainerWatcher.itemContainerId, (Object)itemContainerWatcher);
        }
        watcherMap = mapBuilder.build();
    }
}

