/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.ItemImageLabel;
import dev.thource.runelite.dudewheresmystuff.ItemStack;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.QuantityFormatter;

class ItemBox
extends JPanel {
    private static final String HTML_CLOSE_TAG = "</html>";
    private int itemId = -1;
    private long itemQuantity = 1L;

    ItemBox(DudeWheresMyStuffPlugin plugin, @Nullable ItemStack itemStack, boolean displayEmptyStacks) {
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        if (itemStack != null && itemStack.getId() != -1 && (displayEmptyStacks || itemStack.getQuantity() != 0L)) {
            this.itemId = itemStack.getId();
            this.itemQuantity = itemStack.getQuantity();
            ItemImageLabel imageLabel = new ItemImageLabel(plugin);
            imageLabel.setToolTipText(ItemBox.buildToolTip(itemStack));
            imageLabel.setVerticalAlignment(0);
            imageLabel.setHorizontalAlignment(0);
            imageLabel.setItemStack(itemStack);
            AsyncBufferedImage itemImage = plugin.getItemManager().getImage(itemStack.getId(), (int)Math.min(itemStack.getQuantity(), Integer.MAX_VALUE), itemStack.isStackable() || itemStack.getQuantity() > 1L);
            itemImage.addTo((JLabel)imageLabel);
            this.add(imageLabel);
        }
    }

    private static String buildToolTip(ItemStack item) {
        String name = item.getName();
        long quantity = item.getQuantity();
        long gePrice = item.getTotalGePrice();
        long haPrice = item.getTotalHaPrice();
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(name).append(" x ").append(QuantityFormatter.formatNumber((long)quantity));
        if (item.getId() == 995) {
            sb.append(HTML_CLOSE_TAG);
            return sb.toString();
        }
        if (gePrice > 0L) {
            sb.append("<br>GE: ").append(QuantityFormatter.quantityToStackSize((long)gePrice));
            if (quantity > 1L) {
                sb.append(" (").append(QuantityFormatter.quantityToStackSize((long)item.getGePrice())).append(" ea)");
            }
        }
        if (item.getId() == 13204) {
            sb.append(HTML_CLOSE_TAG);
            return sb.toString();
        }
        if (haPrice > 0L) {
            sb.append("<br>HA: ").append(QuantityFormatter.quantityToStackSize((long)haPrice));
            if (quantity > 1L) {
                sb.append(" (").append(QuantityFormatter.quantityToStackSize((long)item.getHaPrice())).append(" ea)");
            }
        }
        sb.append(HTML_CLOSE_TAG);
        return sb.toString();
    }

    public int getItemId() {
        return this.itemId;
    }

    public long getItemQuantity() {
        return this.itemQuantity;
    }
}

