/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class InvisibleGridLayout
implements LayoutManager,
Serializable {
    private static final String ZERO_ROW_COL_ERROR_TEXT = "rows and cols cannot both be zero";
    private final int hgap;
    private final int vgap;
    private final int rows;
    private final int cols;

    public InvisibleGridLayout(int rows, int cols) {
        this(rows, cols, 0, 0);
    }

    public InvisibleGridLayout(int rows, int cols, int hgap, int vgap) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException(ZERO_ROW_COL_ERROR_TEXT);
        }
        this.rows = rows;
        this.cols = cols;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.getVisibleComponents(parent);
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = 0;
            int h = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                Dimension d = comp.getPreferredSize();
                if (w < d.width) {
                    w = d.width;
                }
                if (h >= d.height) continue;
                h = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.getVisibleComponents(parent);
            int nrows = this.rows;
            int ncols = this.cols;
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = 0;
            int h = 0;
            for (int i = 0; i < parent.getComponentCount(); ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                Dimension d = comp.getMinimumSize();
                if (w < d.width) {
                    w = d.width;
                }
                if (h >= d.height) continue;
                h = d.height;
            }
            return new Dimension(insets.left + insets.right + ncols * w + (ncols - 1) * this.hgap, insets.top + insets.bottom + nrows * h + (nrows - 1) * this.vgap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int ncomponents = this.getVisibleComponents(parent);
            int nrows = this.rows;
            int ncols = this.cols;
            if (ncomponents == 0) {
                return;
            }
            if (nrows > 0) {
                ncols = (ncomponents + nrows - 1) / nrows;
            } else {
                nrows = (ncomponents + ncols - 1) / ncols;
            }
            int w = parent.getSize().width - (insets.left + insets.right);
            int h = parent.getSize().height - (insets.top + insets.bottom);
            w = (w - (ncols - 1) * this.hgap) / ncols;
            h = (h - (nrows - 1) * this.vgap) / nrows;
            int i = 0;
            boolean ltr = parent.getComponentOrientation().isLeftToRight();
            if (ltr) {
                int r = 0;
                int y = insets.top;
                while (r < nrows) {
                    int c = 0;
                    int x = insets.left;
                    while (c < ncols && i < parent.getComponentCount()) {
                        Component component = parent.getComponent(i);
                        if (component.isVisible()) {
                            parent.getComponent(i).setBounds(x, y, w, h);
                            ++c;
                            x += w + this.hgap;
                        }
                        ++i;
                    }
                    ++r;
                    y += h + this.vgap;
                }
            }
        }
    }

    private int getVisibleComponents(Container parent) {
        int visible = 0;
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            ++visible;
        }
        return visible;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + "]";
    }
}

