/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.EnhancedSwingUtilities;
import dev.thource.runelite.dudewheresmystuff.FasterMaterialTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class FasterMaterialTabGroup
extends JPanel {
    private final JPanel display;
    private final List<FasterMaterialTab> tabs = new ArrayList<FasterMaterialTab>();

    FasterMaterialTabGroup(JPanel display) {
        this.display = display;
        if (display != null) {
            this.display.setLayout(new BorderLayout());
        }
        this.setLayout(new FlowLayout(1, 8, 0));
        this.setOpaque(false);
    }

    public void addTab(FasterMaterialTab tab) {
        this.tabs.add(tab);
        this.add((Component)tab, "North");
    }

    public void select(FasterMaterialTab selectedTab) {
        if (!this.tabs.contains(selectedTab)) {
            return;
        }
        if (!selectedTab.select()) {
            return;
        }
        if (this.display != null) {
            EnhancedSwingUtilities.fastRemoveAll(this.display);
            this.display.add(selectedTab.getContent());
            this.display.revalidate();
            this.display.repaint();
        }
        for (FasterMaterialTab tab : this.tabs) {
            if (tab.equals(selectedTab)) continue;
            tab.unselect();
        }
    }
}

