/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import com.google.inject.Provides;
import com.google.inject.name.Named;
import dev.thource.runelite.dudewheresmystuff.ClientState;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffConfig;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPanel;
import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPanelContainer;
import dev.thource.runelite.dudewheresmystuff.ItemContainerWatcher;
import dev.thource.runelite.dudewheresmystuff.ItemCountInputListener;
import dev.thource.runelite.dudewheresmystuff.ItemCountOverlay;
import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import dev.thource.runelite.dudewheresmystuff.SaveMigrator;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StorageManagerManager;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageManager;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageManager;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorageTextOverlay;
import dev.thource.runelite.dudewheresmystuff.death.ExpiringDeathStorageTilesOverlay;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageManager;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageManager;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageManager;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageManager;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.FocusChanged;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ItemDespawned;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfile;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.ConfigSync;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.itemidentification.ItemIdentificationConfig;
import net.runelite.client.plugins.itemidentification.ItemIdentificationPlugin;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Dude, Where's My Stuff?", description="Helps you keep track of your stuff (items, gp, minigame points) by recording and showing you where they are in an easy to view way.", tags={"uim", "storage", "deathbank", "deathstorage", "death", "deathpile", "coins", "poh", "stash", "minigames", "leprechaun", "fossils"})
@PluginDependency(value=ItemIdentificationPlugin.class)
public class DudeWheresMyStuffPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DudeWheresMyStuffPlugin.class);
    private static final String CONFIG_KEY_IS_MEMBER = "isMember";
    private static final String CONFIG_KEY_SAVE_MIGRATED = "saveMigrated";
    @Inject
    protected PluginManager pluginManager;
    @Inject
    protected ItemIdentificationPlugin itemIdentificationPlugin;
    @Inject
    protected ItemIdentificationConfig itemIdentificationConfig;
    @Inject
    @Named(value="developerMode")
    boolean developerMode;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private Notifier notifier;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private DudeWheresMyStuffConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    private ExpiringDeathStorageTilesOverlay expiringDeathStorageTilesOverlay;
    private ExpiringDeathStorageTextOverlay expiringDeathStorageTextOverlay;
    @Inject
    private ItemCountOverlay itemCountOverlay;
    @Inject
    private ItemCountInputListener itemCountInputListener;
    @Inject
    private DeathStorageManager deathStorageManager;
    @Inject
    private DeathStorageManager previewDeathStorageManager;
    @Inject
    private CoinsStorageManager coinsStorageManager;
    @Inject
    private CoinsStorageManager previewCoinsStorageManager;
    @Inject
    private CarryableStorageManager carryableStorageManager;
    @Inject
    private CarryableStorageManager previewCarryableStorageManager;
    @Inject
    private WorldStorageManager worldStorageManager;
    @Inject
    private WorldStorageManager previewWorldStorageManager;
    @Inject
    private StashStorageManager stashStorageManager;
    @Inject
    private StashStorageManager previewStashStorageManager;
    @Inject
    private PlayerOwnedHouseStorageManager playerOwnedHouseStorageManager;
    @Inject
    private PlayerOwnedHouseStorageManager previewPlayerOwnedHouseStorageManager;
    @Inject
    private MinigamesStorageManager minigamesStorageManager;
    @Inject
    private MinigamesStorageManager previewMinigamesStorageManager;
    private StorageManagerManager storageManagerManager;
    private StorageManagerManager previewStorageManagerManager;
    private DudeWheresMyStuffPanelContainer panelContainer;
    private NavigationButton navButton;
    private ClientState clientState = ClientState.LOGGED_OUT;
    private boolean pluginStartedAlreadyLoggedIn;
    private String profileKey;
    private String previewProfileKey;

    public static boolean getConfirmation(Component parentComponent, String text, String confirmText) {
        int result = 2;
        try {
            result = JOptionPane.showConfirmDialog(parentComponent, text, confirmText, 2, 2);
        }
        catch (Exception err) {
            log.warn("Unexpected exception occurred while check for confirm required", (Throwable)err);
        }
        return result == 0;
    }

    Stream<RuneScapeProfile> getProfilesWithData() {
        return this.configManager.getRSProfiles().stream().filter(profile -> this.configManager.getConfiguration("dudewheresmystuff", profile.getKey(), CONFIG_KEY_IS_MEMBER) != null);
    }

    protected void startUp() {
        if (this.panelContainer == null) {
            this.expiringDeathStorageTilesOverlay = new ExpiringDeathStorageTilesOverlay(this.config, this.client, this.deathStorageManager);
            this.expiringDeathStorageTextOverlay = new ExpiringDeathStorageTextOverlay(this.config, this.deathStorageManager, this.client);
            this.deathStorageManager.setCarryableStorageManager(this.carryableStorageManager);
            this.deathStorageManager.setCoinsStorageManager(this.coinsStorageManager);
            this.worldStorageManager.getLeprechaun().setBottomlessBucketStorage(this.carryableStorageManager.getBottomlessBucket());
            this.storageManagerManager = new StorageManagerManager(this, this.carryableStorageManager, this.coinsStorageManager, this.deathStorageManager, this.minigamesStorageManager, this.stashStorageManager, this.playerOwnedHouseStorageManager, this.worldStorageManager);
            this.previewCarryableStorageManager.setPreviewManager(true);
            this.previewCoinsStorageManager.setPreviewManager(true);
            this.previewDeathStorageManager.setPreviewManager(true);
            this.previewMinigamesStorageManager.setPreviewManager(true);
            this.previewStashStorageManager.setPreviewManager(true);
            this.previewPlayerOwnedHouseStorageManager.setPreviewManager(true);
            this.previewWorldStorageManager.setPreviewManager(true);
            this.previewDeathStorageManager.setCarryableStorageManager(this.previewCarryableStorageManager);
            this.previewDeathStorageManager.setCoinsStorageManager(this.previewCoinsStorageManager);
            this.previewWorldStorageManager.getLeprechaun().setBottomlessBucketStorage(this.previewCarryableStorageManager.getBottomlessBucket());
            this.previewStorageManagerManager = new StorageManagerManager(this, this.previewCarryableStorageManager, this.previewCoinsStorageManager, this.previewDeathStorageManager, this.previewMinigamesStorageManager, this.previewStashStorageManager, this.previewPlayerOwnedHouseStorageManager, this.previewWorldStorageManager);
            this.panelContainer = new DudeWheresMyStuffPanelContainer(new DudeWheresMyStuffPanel(this, this.configManager, this.storageManagerManager, false), new DudeWheresMyStuffPanel(this, this.configManager, this.previewStorageManagerManager, true));
            SwingUtilities.invokeLater(() -> {
                this.storageManagerManager.getStorageManagers().forEach(storageManager -> storageManager.getStorages().forEach(o -> o.createStoragePanel((StorageManager<?, ?>)storageManager)));
                this.previewStorageManagerManager.getStorageManagers().forEach(storageManager -> storageManager.getStorages().forEach(o -> o.createStoragePanel((StorageManager<?, ?>)storageManager)));
            });
            this.clientThread.invoke(() -> {
                this.navButton = this.buildNavigationButton();
            });
            ItemContainerWatcher.init(this.client);
        }
        this.reset();
        this.clientThread.invoke(() -> this.clientToolbar.addNavigation(this.navButton));
        AtomicBoolean anyProfilesMigrated = new AtomicBoolean(false);
        this.getProfilesWithData().forEach(runeScapeProfile -> {
            if (this.configManager.getConfiguration("dudewheresmystuff", runeScapeProfile.getKey(), CONFIG_KEY_SAVE_MIGRATED) == null) {
                new SaveMigrator(this.configManager, runeScapeProfile.getKey()).migrate();
                anyProfilesMigrated.set(true);
            }
        });
        if (anyProfilesMigrated.get()) {
            this.configManager.sendConfig();
        }
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientState = ClientState.LOGGING_IN;
            this.pluginStartedAlreadyLoggedIn = true;
        } else if (this.client.getGameState() == GameState.LOGGING_IN) {
            this.clientState = ClientState.LOGGING_IN;
        }
        this.deathStorageManager.refreshInfoBoxes();
        this.overlayManager.add((Overlay)this.expiringDeathStorageTextOverlay);
        this.overlayManager.add((Overlay)this.expiringDeathStorageTilesOverlay);
        this.overlayManager.add((Overlay)this.itemCountOverlay);
        this.itemCountInputListener.setItemCountOverlay(this.itemCountOverlay);
        this.keyManager.registerKeyListener((KeyListener)this.itemCountInputListener);
    }

    private void reset() {
        this.clientState = ClientState.LOGGED_OUT;
        ItemContainerWatcher.reset();
        this.storageManagerManager.reset();
        this.panelContainer.reset();
    }

    protected void shutDown() {
        this.save();
        this.clientToolbar.removeNavigation(this.navButton);
        this.infoBoxManager.removeIf(infoBox -> infoBox.getName().startsWith(((Object)((Object)this)).getClass().getSimpleName()));
        this.overlayManager.remove((Overlay)this.expiringDeathStorageTextOverlay);
        this.overlayManager.remove((Overlay)this.expiringDeathStorageTilesOverlay);
        this.overlayManager.remove((Overlay)this.itemCountOverlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.itemCountInputListener);
    }

    @Subscribe
    public void onFocusChanged(FocusChanged focusChanged) {
        if (!focusChanged.isFocused()) {
            this.itemCountOverlay.setKeybindPressed(false);
        }
    }

    @Subscribe
    public void onConfigSync(ConfigSync configSync) {
        this.save();
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown clientShutdown) {
        this.save();
    }

    private void load(String profileKey) {
        this.profileKey = profileKey;
        this.clientThread.invokeLater(() -> {
            this.storageManagerManager.reset();
            this.storageManagerManager.load(profileKey);
            SwingUtilities.invokeLater(this.panelContainer.getPanel()::softUpdate);
        });
    }

    private void save() {
        if (this.profileKey == null) {
            return;
        }
        this.storageManagerManager.save(this.profileKey);
    }

    @Subscribe
    void onConfigChanged(ConfigChanged configChanged) {
        if (!Objects.equals(configChanged.getGroup(), "dudewheresmystuff")) {
            return;
        }
        switch (configChanged.getKey()) {
            case "showEmptyStorages": {
                this.panelContainer.reorderStoragePanels();
                break;
            }
            case "sidebarIcon": {
                this.clientThread.invoke(() -> {
                    this.clientToolbar.removeNavigation(this.navButton);
                    this.navButton = this.buildNavigationButton();
                    this.clientToolbar.addNavigation(this.navButton);
                });
                break;
            }
            case "itemSortMode": {
                this.setItemSortMode(ItemSortMode.valueOf(configChanged.getNewValue()));
                break;
            }
            case "deathpilesUseAccountPlayTime": 
            case "deathbankInfoBox": 
            case "deathpileInfoBox": {
                this.deathStorageManager.refreshInfoBoxes();
                break;
            }
        }
    }

    private NavigationButton buildNavigationButton() {
        return NavigationButton.builder().tooltip("Dude, Where's My Stuff?").icon(this.config.sidebarIcon().getIcon(this.itemManager)).panel((PluginPanel)this.panelContainer).priority(4).build();
    }

    @Subscribe
    void onActorDeath(ActorDeath actorDeath) {
        this.storageManagerManager.onActorDeath(actorDeath);
    }

    @Subscribe
    void onChatMessage(ChatMessage chatMessage) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onChatMessage(chatMessage);
    }

    private String toTitleCase(String str) {
        if (str == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("(_|^)(\\w)([^_]*)");
        Matcher matcher = pattern.matcher(str.toLowerCase());
        StringBuilder builder = new StringBuilder();
        while (matcher.find()) {
            builder.append(matcher.group(1)).append(matcher.group(2).toUpperCase()).append(matcher.group(3));
        }
        return builder.toString().replace("_", " ");
    }

    public String getDisplayName(String profileKey) {
        RuneScapeProfile profile = this.configManager.getRSProfiles().stream().filter(p -> p.getKey().equals(profileKey)).findFirst().orElse(null);
        return this.getDisplayName(profile);
    }

    public String getDisplayName(RuneScapeProfile profile) {
        if (profile == null) {
            return "Unknown";
        }
        Object displayName = profile.getDisplayName();
        if (profile.getType() != RuneScapeProfileType.STANDARD) {
            displayName = (String)displayName + " - " + this.toTitleCase(profile.getType().toString());
        }
        return displayName;
    }

    @Subscribe
    void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        this.save();
        this.load(this.configManager.getRSProfileKey());
        String displayName = this.getDisplayName(this.configManager.getRSProfileKey());
        if (Objects.equals(displayName, this.panelContainer.getPreviewPanel().getDisplayName())) {
            this.disablePreviewMode(false);
        }
        this.panelContainer.getPanel().setDisplayName(displayName);
    }

    @Subscribe
    void onGameStateChanged(GameStateChanged gameStateChanged) {
        this.storageManagerManager.onGameStateChanged(gameStateChanged);
        if (gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.clientState = ClientState.LOGGING_IN;
        }
    }

    @Subscribe
    void onGameTick(GameTick gameTick) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        if (this.clientState == ClientState.LOGGING_IN) {
            boolean isMember = this.client.getVarcIntValue(103) == 1;
            int accountType = this.client.getVarbitValue(1777);
            String displayName = this.getDisplayName(this.configManager.getRSProfileKey());
            if (this.configManager.getRSProfileConfiguration("dudewheresmystuff", CONFIG_KEY_SAVE_MIGRATED) == null) {
                this.configManager.setRSProfileConfiguration("dudewheresmystuff", CONFIG_KEY_SAVE_MIGRATED, (Object)true);
            }
            this.configManager.setRSProfileConfiguration("dudewheresmystuff", CONFIG_KEY_IS_MEMBER, (Object)isMember);
            this.configManager.setRSProfileConfiguration("dudewheresmystuff", "accountType", (Object)accountType);
            this.panelContainer.getPanel().logIn(isMember, accountType, displayName);
            this.clientState = ClientState.LOGGED_IN;
            if (this.pluginStartedAlreadyLoggedIn) {
                this.load(this.configManager.getRSProfileKey());
                for (ItemContainer itemContainer : this.client.getItemContainers()) {
                    this.onItemContainerChanged(new ItemContainerChanged(itemContainer.getId(), itemContainer));
                }
                this.onVarbitChanged(new VarbitChanged());
                this.panelContainer.getPanel().setDisplayName(this.getDisplayName(this.configManager.getRSProfileKey()));
                this.pluginStartedAlreadyLoggedIn = false;
            }
            SwingUtilities.invokeLater(this.panelContainer.getPanel()::softUpdate);
            return;
        }
        this.expiringDeathStorageTextOverlay.updateSoonestExpiringDeathStorage();
        ItemContainerWatcher.onGameTick(this);
        this.storageManagerManager.onGameTick();
        SwingUtilities.invokeLater(this.panelContainer::softUpdate);
    }

    @Subscribe
    void onMenuOptionClicked(MenuOptionClicked menuOption) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onMenuOptionClicked(menuOption);
    }

    @Subscribe
    void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onWidgetLoaded(widgetLoaded);
    }

    @Subscribe
    void onWidgetClosed(WidgetClosed widgetClosed) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onWidgetClosed(widgetClosed);
    }

    @Subscribe
    void onVarbitChanged(VarbitChanged varbitChanged) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onVarbitChanged();
    }

    @Subscribe
    void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onItemContainerChanged(itemContainerChanged);
    }

    @Subscribe
    void onItemDespawned(ItemDespawned itemDespawned) {
        if (this.clientState == ClientState.LOGGED_OUT) {
            return;
        }
        this.storageManagerManager.onItemDespawned(itemDespawned);
    }

    @Provides
    DudeWheresMyStuffConfig provideConfig(ConfigManager configManager) {
        return (DudeWheresMyStuffConfig)configManager.getConfig(DudeWheresMyStuffConfig.class);
    }

    void disablePreviewMode(boolean deleteData) {
        this.previewStorageManagerManager.reset();
        if (deleteData) {
            for (String key : this.configManager.getRSProfileConfigurationKeys("dudewheresmystuff", this.previewProfileKey, "")) {
                this.configManager.unsetConfiguration("dudewheresmystuff", this.previewProfileKey, key);
            }
            if (Objects.equals(this.previewProfileKey, this.configManager.getRSProfileKey())) {
                this.storageManagerManager.reset();
                this.storageManagerManager.getStorageManagers().forEach(storageManager -> {
                    storageManager.getStorages().forEach(storage -> {
                        if (storage.getStoragePanel() != null) {
                            storage.getStoragePanel().refreshItems();
                            SwingUtilities.invokeLater(() -> storage.getStoragePanel().update());
                        }
                    });
                    SwingUtilities.invokeLater(() -> storageManager.getStorageTabPanel().reorderStoragePanels());
                });
            }
        }
        SwingUtilities.invokeLater(() -> {
            this.panelContainer.getPreviewPanel().logOut();
            this.panelContainer.disablePreviewMode();
        });
        this.previewProfileKey = null;
    }

    void enablePreviewMode(String profileKey, String displayName) {
        this.previewProfileKey = profileKey;
        Integer playedMinutes = (Integer)this.configManager.getConfiguration("dudewheresmystuff", profileKey, "minutesPlayed", Integer.TYPE);
        this.previewDeathStorageManager.setStartPlayedMinutes(playedMinutes == null ? 0 : playedMinutes);
        this.clientThread.invoke(() -> {
            this.previewStorageManagerManager.load(profileKey);
            this.panelContainer.getPreviewPanel().logIn((Boolean)this.configManager.getConfiguration("dudewheresmystuff", profileKey, CONFIG_KEY_IS_MEMBER, Boolean.TYPE), (Integer)this.configManager.getConfiguration("dudewheresmystuff", profileKey, "accountType", Integer.TYPE), displayName);
            this.panelContainer.enablePreviewMode();
        });
    }

    public void setItemSortMode(ItemSortMode itemSortMode) {
        this.panelContainer.setItemSortMode(itemSortMode);
    }

    void deleteAllData() {
        this.getProfilesWithData().forEach(runeScapeProfile -> {
            for (String configKey : this.configManager.getRSProfileConfigurationKeys("dudewheresmystuff", runeScapeProfile.getKey(), "")) {
                this.configManager.unsetConfiguration("dudewheresmystuff", runeScapeProfile.getKey(), configKey);
            }
        });
        this.configManager.sendConfig();
    }

    public long getWithdrawableItemCount(int id) {
        int canonicalId = this.itemManager.canonicalize(id);
        return this.storageManagerManager.getStorages().filter(Storage::isWithdrawable).mapToLong(storage -> storage.getItemCount(canonicalId)).sum();
    }

    public Map<Storage<?>, Long> getDetailedWithdrawableItemCount(int id) {
        int canonicalId = this.itemManager.canonicalize(id);
        HashMap map = new HashMap();
        this.storageManagerManager.getStorages().filter(Storage::isWithdrawable).forEach(storage -> {
            long count = storage.getItemCount(canonicalId);
            if (count > 0L) {
                map.put((Storage<?>)storage, count);
            }
        });
        return map;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ItemIdentificationPlugin getItemIdentificationPlugin() {
        return this.itemIdentificationPlugin;
    }

    public ItemIdentificationConfig getItemIdentificationConfig() {
        return this.itemIdentificationConfig;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public Client getClient() {
        return this.client;
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }

    public InfoBoxManager getInfoBoxManager() {
        return this.infoBoxManager;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public DudeWheresMyStuffConfig getConfig() {
        return this.config;
    }

    public String getPreviewProfileKey() {
        return this.previewProfileKey;
    }
}

