/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPanel;
import dev.thource.runelite.dudewheresmystuff.InvisibleGridLayout;
import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.PluginPanel;

public class DudeWheresMyStuffPanelContainer
extends PluginPanel {
    private final DudeWheresMyStuffPanel panel;
    private final DudeWheresMyStuffPanel previewPanel;
    private boolean previewing;
    private boolean active;

    DudeWheresMyStuffPanelContainer(DudeWheresMyStuffPanel panel, DudeWheresMyStuffPanel previewPanel) {
        super(false);
        this.panel = panel;
        this.previewPanel = previewPanel;
        this.setLayout(new InvisibleGridLayout(0, 1));
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.add(panel);
        this.add(previewPanel);
        this.reset();
    }

    void reset() {
        this.panel.reset();
        this.previewPanel.reset();
        this.disablePreviewMode();
    }

    void disablePreviewMode() {
        this.panel.setVisible(true);
        this.panel.setActive(this.active);
        this.previewPanel.setVisible(false);
        this.previewPanel.setActive(false);
        this.previewing = false;
        this.softUpdate();
    }

    void enablePreviewMode() {
        this.panel.setVisible(false);
        this.panel.setActive(false);
        this.previewPanel.setVisible(true);
        this.previewPanel.setActive(this.active);
        this.previewing = true;
        this.softUpdate();
    }

    void softUpdate() {
        if (!this.active) {
            return;
        }
        this.previewPanel.softUpdate();
        this.panel.softUpdate();
    }

    public void onActivate() {
        this.active = true;
        if (this.previewing) {
            this.previewPanel.setActive(true);
        } else {
            this.panel.setActive(true);
        }
        this.softUpdate();
    }

    public void onDeactivate() {
        this.active = false;
        this.previewPanel.setActive(false);
        this.panel.setActive(false);
    }

    void reorderStoragePanels() {
        if (this.previewing) {
            this.previewPanel.reorderStoragePanels();
        } else {
            this.panel.reorderStoragePanels();
        }
    }

    void setItemSortMode(ItemSortMode itemSortMode) {
        this.panel.setItemSortMode(itemSortMode);
        this.previewPanel.setItemSortMode(itemSortMode);
    }

    public DudeWheresMyStuffPanel getPanel() {
        return this.panel;
    }

    public DudeWheresMyStuffPanel getPreviewPanel() {
        return this.previewPanel;
    }
}

