/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.DudeWheresMyStuffPlugin;
import dev.thource.runelite.dudewheresmystuff.FasterMaterialTab;
import dev.thource.runelite.dudewheresmystuff.FasterMaterialTabGroup;
import dev.thource.runelite.dudewheresmystuff.InvisibleGridLayout;
import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import dev.thource.runelite.dudewheresmystuff.OverviewTabPanel;
import dev.thource.runelite.dudewheresmystuff.ScrollableContainer;
import dev.thource.runelite.dudewheresmystuff.SearchTabPanel;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StorageManagerManager;
import dev.thource.runelite.dudewheresmystuff.StorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.Tab;
import dev.thource.runelite.dudewheresmystuff.TabContentPanel;
import dev.thource.runelite.dudewheresmystuff.carryable.CarryableStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.coins.CoinsStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.death.DeathStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.minigames.MinigamesStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.playerownedhouse.PlayerOwnedHouseStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.stash.StashStorageTabPanel;
import dev.thource.runelite.dudewheresmystuff.world.WorldStorageTabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

public class DudeWheresMyStuffPanel
extends JPanel {
    private static final ImageIcon SEARCH_ICON = new ImageIcon(ImageUtil.loadImageResource(DudeWheresMyStuffPlugin.class, (String)"/net/runelite/client/ui/components/search.png"));
    private final EnumMap<Tab, FasterMaterialTab> uiTabs = new EnumMap(Tab.class);
    private final OverviewTabPanel overviewTab;
    private final EnumMap<Tab, StorageTabPanel<?, ?, ?>> storageTabPanelMap = new EnumMap(Tab.class);
    private final transient ItemManager itemManager;
    private final JPanel display = new JPanel();
    private final FasterMaterialTabGroup tabGroup = new FasterMaterialTabGroup(this.display);
    private final boolean previewMode;
    private final transient StorageManagerManager storageManagerManager;
    private final transient DudeWheresMyStuffPlugin plugin;
    private boolean active;
    private String displayName = "";
    @Nullable
    private TabContentPanel activeTabPanel = null;

    DudeWheresMyStuffPanel(DudeWheresMyStuffPlugin plugin, ConfigManager configManager, StorageManagerManager storageManagerManager, boolean previewMode) {
        this.plugin = plugin;
        this.itemManager = plugin.getItemManager();
        this.storageManagerManager = storageManagerManager;
        this.previewMode = previewMode;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.display.setBorder(new EmptyBorder(10, 10, 8, 10));
        this.tabGroup.setLayout(new InvisibleGridLayout(0, 6, 7, 7));
        this.tabGroup.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.add((Component)this.tabGroup, "North");
        this.add((Component)this.display, "Center");
        this.overviewTab = new OverviewTabPanel(plugin, this, this.itemManager, configManager, storageManagerManager, plugin.isDeveloperMode());
        this.addTab(Tab.OVERVIEW, this.overviewTab);
        this.addTab(Tab.DEATH, new DeathStorageTabPanel(plugin, storageManagerManager.getDeathStorageManager()));
        this.addTab(Tab.COINS, new CoinsStorageTabPanel(plugin, storageManagerManager.getCoinsStorageManager()));
        this.addTab(Tab.CARRYABLE_STORAGE, new CarryableStorageTabPanel(plugin, storageManagerManager.getCarryableStorageManager()));
        this.addTab(Tab.STASH_UNITS, new StashStorageTabPanel(plugin, storageManagerManager.getStashStorageManager()));
        this.addTab(Tab.POH_STORAGE, new PlayerOwnedHouseStorageTabPanel(plugin, storageManagerManager.getPlayerOwnedHouseStorageManager()));
        this.addTab(Tab.WORLD, new WorldStorageTabPanel(plugin, storageManagerManager.getWorldStorageManager()));
        this.addTab(Tab.MINIGAMES, new MinigamesStorageTabPanel(plugin, storageManagerManager.getMinigamesStorageManager()));
        this.addTab(Tab.SEARCH, new SearchTabPanel(plugin, storageManagerManager));
        for (Tab tab : Tab.TABS) {
            if (tab == Tab.OVERVIEW) continue;
            Optional.ofNullable(this.uiTabs.get((Object)tab)).ifPresent(materialTab -> materialTab.setVisible(false));
        }
    }

    void setItemSortMode(ItemSortMode itemSortMode) {
        this.storageTabPanelMap.forEach((tab, tabPanel) -> {
            if (tab == Tab.OVERVIEW) {
                return;
            }
            this.plugin.getClientThread().invoke(() -> ((StorageManager)tabPanel.getStorageManager()).getStorages().stream().map(Storage::getStoragePanel).filter(Objects::nonNull).forEach(panel -> {
                panel.refreshItems();
                SwingUtilities.invokeLater(panel::update);
            }));
            JComboBox<ItemSortMode> sortDropdown = tabPanel.getSortItemsDropdown();
            ItemListener[] itemListeners = sortDropdown.getItemListeners();
            Arrays.stream(itemListeners).forEach(sortDropdown::removeItemListener);
            sortDropdown.setSelectedItem((Object)itemSortMode);
            Arrays.stream(itemListeners).forEach(sortDropdown::addItemListener);
        });
        ((SearchTabPanel)this.storageTabPanelMap.get((Object)Tab.SEARCH)).refreshItemSortMode();
    }

    private void addTab(Tab tab, TabContentPanel tabContentPanel) {
        if (tabContentPanel instanceof StorageTabPanel) {
            this.storageTabPanelMap.put(tab, (StorageTabPanel)tabContentPanel);
        }
        JPanel wrapped = new JPanel(new BorderLayout());
        wrapped.add((Component)tabContentPanel, "North");
        wrapped.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JScrollPane scrollPane = new JScrollPane(new ScrollableContainer(wrapped));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(16, 0));
        scrollPane.getVerticalScrollBar().setBorder(new EmptyBorder(0, 9, 0, 0));
        scrollPane.getVerticalScrollBar().setUnitIncrement(21);
        scrollPane.setBackground(ColorScheme.DARK_GRAY_COLOR);
        FasterMaterialTab materialTab = new FasterMaterialTab(new ImageIcon(), this.tabGroup, scrollPane);
        materialTab.setPreferredSize(new Dimension(30, 27));
        materialTab.setName(tab.getName());
        materialTab.setToolTipText(tab.getName());
        if (tab == Tab.SEARCH) {
            materialTab.setIcon(SEARCH_ICON);
        } else {
            AsyncBufferedImage icon = this.itemManager.getImage(tab.getItemId(), tab.getItemQuantity(), false);
            Runnable resize = () -> {
                BufferedImage subIcon = icon.getSubimage(0, 0, 32, 32);
                materialTab.setIcon(new ImageIcon(subIcon.getScaledInstance(24, 24, 4)));
            };
            icon.onLoaded(resize);
            resize.run();
        }
        materialTab.setOnSelectEvent(() -> {
            this.activeTabPanel = tabContentPanel;
            this.softUpdate();
            return true;
        });
        this.uiTabs.put(tab, materialTab);
        this.tabGroup.addTab(materialTab);
        if (tab == Tab.OVERVIEW) {
            this.tabGroup.select(materialTab);
        }
    }

    void switchTab(Tab tab) {
        this.tabGroup.select(this.uiTabs.get((Object)tab));
    }

    void softUpdate() {
        if (!this.active || this.activeTabPanel == null) {
            return;
        }
        this.activeTabPanel.softUpdate();
    }

    void setDisplayName(String name) {
        this.displayName = name;
        this.storageManagerManager.setDisplayName(name);
    }

    void reset() {
        SwingUtilities.invokeLater(() -> {
            this.logOut();
            this.softUpdate();
        });
    }

    void logOut() {
        this.uiTabs.forEach((tab, materialTab) -> {
            if (tab == Tab.OVERVIEW) {
                return;
            }
            materialTab.setVisible(false);
        });
        this.overviewTab.getOverviews().forEach((tab, overviewItemPanel) -> {
            if (tab == Tab.OVERVIEW) {
                return;
            }
            overviewItemPanel.setVisible(false);
        });
        ((SearchTabPanel)this.storageTabPanelMap.get((Object)Tab.SEARCH)).getSearchBar().setText("");
        this.switchTab(Tab.OVERVIEW);
        this.setDisplayName("");
    }

    void logIn(boolean isMember, int accountType, String displayName) {
        this.storageTabPanelMap.forEach((tab, storageTabPanel) -> {
            Object storageManager = storageTabPanel.storageManager;
            if (storageManager != null) {
                ((StorageManager)storageManager).getStorages().forEach(storage -> storage.disable(isMember, accountType));
                if (tab != Tab.DEATH && ((StorageManager)storageManager).getStorages().stream().noneMatch(Storage::isEnabled)) {
                    ((StorageManager)storageManager).disable();
                    return;
                }
            }
            Optional.ofNullable(this.uiTabs.get(tab)).ifPresent(materialTab -> materialTab.setVisible(true));
            Optional.ofNullable(this.overviewTab.getOverviews().get(tab)).ifPresent(overviewItemPanel -> overviewItemPanel.setVisible(true));
        });
        this.uiTabs.get((Object)Tab.SEARCH).setVisible(true);
        this.setDisplayName(displayName);
    }

    public boolean isPreviewPanel() {
        return this.previewMode;
    }

    void reorderStoragePanels() {
        this.storageManagerManager.getStorageManagers().forEach(storageManager -> storageManager.getStorageTabPanel().reorderStoragePanels());
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

