/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.ItemSortMode;
import dev.thource.runelite.dudewheresmystuff.SidebarIcon;
import dev.thource.runelite.dudewheresmystuff.StoredItemCountTooltipMode;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Keybind;
import net.runelite.client.config.Range;

@ConfigGroup(value="dudewheresmystuff")
public interface DudeWheresMyStuffConfig
extends Config {
    public static final String CONFIG_GROUP = "dudewheresmystuff";
    @ConfigSection(name="Deathpiles / Graves Options", description="Settings for deathpiles and graves", position=100)
    public static final String DEATHPILE_OPTIONS_SECTION = "Deathpiles / Graves Options";

    @ConfigItem(keyName="showEmptyStorages", name="Show empty storages", description="Whether storages with no items should be shown")
    default public boolean showEmptyStorages() {
        return true;
    }

    @ConfigItem(keyName="sidebarIcon", name="Sidebar icon", description="Which icon to display in the RuneLite sidebar")
    default public SidebarIcon sidebarIcon() {
        return SidebarIcon.DEFAULT;
    }

    @ConfigItem(keyName="csvCombineItems", name="Combine items in CSV", description="When enabled, items from different storages will be combined into a single row in the exported CSV file. This means that the CSV won't contain which item is in which storage.")
    default public boolean csvCombineItems() {
        return false;
    }

    @ConfigItem(keyName="storedItemCountTooltip", name="Item Count Tooltip Mode", description="Adds a tooltip when you hover items that tells you how many of those item you have stored. \"Simple\" mode shows a sum, \"Detailed\" mode tells you where they are stored.")
    default public StoredItemCountTooltipMode storedItemCountTooltip() {
        return StoredItemCountTooltipMode.OFF;
    }

    @ConfigItem(keyName="storedItemCountTooltipKeybind", name="Item Count Tooltip Keybind", description="Hold this key down to display the item count tooltip.")
    default public Keybind storedItemCountTooltipKeybind() {
        return Keybind.NOT_SET;
    }

    @ConfigItem(keyName="deathbankInfoBox", name="Show infobox for deathbank", description="When enabled, an infobox will be displayed while you have an active deathbank.")
    default public boolean deathbankInfoBox() {
        return true;
    }

    @ConfigItem(keyName="deathpilesUseAccountPlayTime", name="Cross-client tracking", description="When enabled, deathpile/grave expiry will be based on account play time, this means that if you play for 5 minutes on another client (like mobile) your deathpile/grave timer will still be accurate.<br><br>Using this option requires you to set your quest tab to the \"Character summary\" tab (brown star icon) once per login. With this option enabled, an infobox will be displayed prompting you to swap to the \"Character summary\" tab when the plugin doesn't know your play time.<br><br>If the plugin doesn't know your play time at the time of your death, the deathpile/grave will default to non cross-client tracking mode.", section="Deathpiles / Graves Options", position=101)
    default public boolean deathpilesUseAccountPlayTime() {
        return false;
    }

    @ConfigItem(keyName="deathpileInfoBox", name="Show infoboxes", description="When enabled, infoboxes will be displayed while you have active deathpiles / graves.", section="Deathpiles / Graves Options", position=102)
    default public boolean deathpileInfoBox() {
        return true;
    }

    @Range(min=1, max=59)
    @ConfigItem(keyName="deathpileContingencyMinutes", name="Contingency (minutes)", description="This amount of minutes is removed from the deathpile / grave timer. If set to 15, any new deathpiles / graves will start with 45 minutes until expiry.", section="Deathpiles / Graves Options", position=104)
    default public int deathpileContingencyMinutes() {
        return 1;
    }

    @ConfigItem(keyName="flashExpiringDeathpileInfoboxes", name="Flash expiring infoboxes", description="Flash the infoboxes of expiring deathpiles / graves red.", section="Deathpiles / Graves Options", position=105)
    default public boolean flashExpiringDeathpileInfoboxes() {
        return true;
    }

    @ConfigItem(keyName="flashExpiringDeathpileTiles", name="Flash expiring tiles", description="Flash the tile borders of expiring deathpiles / graves red.", section="Deathpiles / Graves Options", position=106)
    default public boolean flashExpiringDeathpileTiles() {
        return true;
    }

    @ConfigItem(keyName="showDeathpileExpiryText", name="Show expiry text", description="Show on-screen text when your oldest deathpile / grave is expiring.", section="Deathpiles / Graves Options", position=107)
    default public boolean showDeathpileExpiryText() {
        return false;
    }

    @ConfigItem(keyName="deathpileExpiryWarningTime", name="Expiry warning time", description="The minutes remaining on your oldest deathpile / grave before you start getting alerted.", section="Deathpiles / Graves Options", position=108)
    default public int deathpileExpiryWarningTime() {
        return 5;
    }

    @ConfigItem(keyName="deathpileExpiryWarningFontSize", name="Expiry font size", description="Font size for the deathpile / grave expiry text warning.", section="Deathpiles / Graves Options", position=109)
    default public int deathpileExpiryWarningFontSize() {
        return 32;
    }

    @ConfigItem(keyName="itemSortMode", name="Item Sort Mode", description="Which mode to use when sorting items", hidden=true)
    default public ItemSortMode itemSortMode() {
        return ItemSortMode.UNSORTED;
    }

    @ConfigItem(keyName="itemSortMode", name="", description="", hidden=true)
    public void setItemSortMode(ItemSortMode var1);
}

