/*
 * Decompiled with CFR 0.152.
 */
package dev.thource.runelite.dudewheresmystuff;

import dev.thource.runelite.dudewheresmystuff.ItemStack;
import dev.thource.runelite.dudewheresmystuff.Storage;
import dev.thource.runelite.dudewheresmystuff.StorageManager;
import dev.thource.runelite.dudewheresmystuff.StorageManagerManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.runelite.client.RuneLite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataExporter {
    private static final Logger log = LoggerFactory.getLogger(DataExporter.class);
    private static final File EXPORT_DIR = new File(RuneLite.RUNELITE_DIR, "dudewheresmystuff");
    private final String displayName;
    private final StorageManagerManager storageManagerManager;
    private boolean mergeItems = false;

    DataExporter(String displayName, StorageManagerManager storageManagerManager) {
        this.displayName = displayName;
        this.storageManagerManager = storageManagerManager;
    }

    void writeItemStack(BufferedWriter writer, ItemStack itemStack) throws IOException {
        this.writeItemStack(writer, itemStack, null, null);
    }

    void writeItemStack(BufferedWriter writer, ItemStack itemStack, @Nullable StorageManager<?, ?> storageManager, @Nullable Storage<?> storage) throws IOException {
        Object name = itemStack.getName();
        if (!this.mergeItems && itemStack.getId() != itemStack.getCanonicalId() && itemStack.isStackable()) {
            name = (String)name + " (noted)";
        }
        String escapedName = ((String)name).replace(",", "").replace("\n", "");
        writer.write(String.format("%d,%s,%d", itemStack.getCanonicalId(), escapedName, itemStack.getQuantity()));
        if (!this.mergeItems && storage != null && storageManager != null) {
            writer.write(String.format(",%s,%s", storageManager.getConfigKey(), storage.getName()));
        }
        writer.write(String.format("%n", new Object[0]));
    }

    void writeMergedItems(BufferedWriter writer) throws IOException {
        writer.write("ID,Name,Quantity\n");
        for (ItemStack itemStack : this.getMergedItems()) {
            this.writeItemStack(writer, itemStack);
        }
    }

    void writeStorageManager(BufferedWriter writer, StorageManager<?, ?> storageManager) throws IOException {
        if (!storageManager.isEnabled()) {
            return;
        }
        for (Storage storage : storageManager.getStorages()) {
            if (!storage.isEnabled() || !storage.isWithdrawable()) continue;
            for (ItemStack itemStack : storage.getItems()) {
                if (itemStack.getQuantity() == 0L || itemStack.getId() == -1) continue;
                this.writeItemStack(writer, itemStack, storageManager, storage);
            }
        }
    }

    void writeAll(BufferedWriter writer) throws IOException {
        writer.write("ID,Name,Quantity,Storage Category,Storage Type\n");
        for (StorageManager<?, ?> storageManager : this.storageManagerManager.getStorageManagers()) {
            this.writeStorageManager(writer, storageManager);
        }
    }

    String export() throws IllegalArgumentException, IOException {
        if (this.displayName.equals("")) {
            throw new IllegalArgumentException("No display name");
        }
        File userDir = new File(EXPORT_DIR, this.displayName);
        String fileName = new SimpleDateFormat("yyyyMMdd'T'HHmmss'.csv'").format(new Date());
        String filePath = userDir + File.separator + fileName;
        userDir.mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            if (this.mergeItems) {
                this.writeMergedItems(writer);
            } else {
                this.writeAll(writer);
            }
        }
        return filePath;
    }

    private Collection<ItemStack> getMergedItems() {
        TreeMap items = new TreeMap();
        this.storageManagerManager.getStorages().filter(Storage::isWithdrawable).map(Storage::getItems).flatMap(Collection::stream).forEach(stack -> {
            if (stack.getQuantity() == 0L || stack.getId() == -1) {
                return;
            }
            int id = stack.getCanonicalId();
            ItemStack existing = (ItemStack)items.get(id);
            if (existing == null) {
                items.put(id, new ItemStack((ItemStack)stack));
            } else {
                existing.setQuantity(stack.getQuantity() + existing.getQuantity());
            }
        });
        return items.values();
    }

    public void setMergeItems(boolean mergeItems) {
        this.mergeItems = mergeItems;
    }
}

