/*
 * Decompiled with CFR 0.152.
 */
package me.lucaspickering.utils;

import java.util.List;
import me.lucaspickering.utils.Herb;
import me.lucaspickering.utils.HerbPatchResult;

public class HerbResult {
    private final Herb herb;
    private final List<HerbPatchResult> patches;

    public HerbResult(Herb herb, List<HerbPatchResult> patches) {
        this.herb = herb;
        this.patches = patches;
    }

    public double getSurvivalChance() {
        return this.patches.stream().mapToDouble(HerbPatchResult::getSurvivalChance).average().orElse(0.0);
    }

    public double getExpectedYield() {
        return this.patches.stream().mapToDouble(HerbPatchResult::getExpectedYield).sum();
    }

    public double getExpectedXp() {
        return this.patches.stream().mapToDouble(HerbPatchResult::getExpectedXp).sum();
    }

    public double getProfit() {
        return this.patches.stream().mapToDouble(HerbPatchResult::getProfit).sum();
    }

    public String toString() {
        return String.format("%f survival / %f yield / %f XP", this.getSurvivalChance() * 100.0, this.getExpectedYield(), this.getExpectedXp());
    }

    public Herb getHerb() {
        return this.herb;
    }
}

